<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($title); ?> - <?php echo e(date('d F Y')); ?></title>
    <link rel="stylesheet" href="/assets/compiled/css/app.css">

</head>

<body class="bg-white">
    <div class="mt-4">
        <h3 class="">Laporan Data Siswa Gudang Sobat Telat</h3>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Tanggal Dicetak :</div>
            <span><?php echo e(date('d F Y - H : i')); ?></span>
        </div>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Jumlah Siswa Terdata :</div>
            <span><?php echo e($siswas->count()); ?> Siswa</span>
        </div>

        <table class="table table-striped">
            <thead class="bg-primary">
                <th class="text-white">No</th>
                <th class="text-white">NIS</th>
                <th class="text-white">NISN</th>
                <th class="text-white">Nama</th>
                <th class="text-white">Gender</th>
                <th class="text-white">Kelas</th>
            </thead>
            <tbody>
                <?php $__currentLoopData = $siswas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i + 1); ?></td>
                        <td><?php echo e($item->nis); ?></td>
                        <td><?php echo e($item->nisn); ?></td>
                        <td><?php echo e($item->nama); ?></td>
                        <td><?php echo e($item->gender); ?></td>
                        <td><?php echo e($item->kelas->kelas); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
<?php /**PATH /home/zona4001/public_html/sobat_telat/resources/views/admin/master/siswa/data_siswa_export.blade.php ENDPATH**/ ?>