<?php $__env->startSection('content_admin'); ?>
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="/assets/extensions/filepond/filepond.css">


    <div class="row">
        <div class="col-12">
            <?php echo $__env->make('alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Data Guru Piket Sobat Telat</h4>
                    <div class="d-flex justify-content-between align-items-center gap-3">
                        <button class="btn btn-primary d-flex justify-content-center align-items-center" data-bs-toggle="modal" data-bs-target="#aksiLainnyaModal">
                            <i class="bi bi-three-dots-vertical mb-2 me-md-1"></i>
                            <small class="d-none d-md-block">Aksi Lainnya</small>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>NIP</th>
                                    
                                    <th>Nama</th>
                                    <th>Gender</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $guru_pikets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i + 1); ?></td>
                                        <td><?php echo e($item->nis); ?></td>
                                        
                                        <td><?php echo e($item->nama); ?></td>
                                        <td><?php echo e($item->gender); ?></td>
                                        <td>
                                            <div class="d-flex justify-content-start align-items-center gap-2">
                                                <button class="btn btn-light-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editBarangModal" onclick="edit(<?php echo e($item->id); ?>)">
                                                    <i class="bi bi-pencil-fill mb-2"></i>
                                                </button>
                                                <button class="btn btn-light-warning" data-bs-toggle="modal"
                                                    data-bs-target="#print_preview_modal"
                                                    onclick="generateQRCode('<?php echo e($item->id); ?>', 'Konfirmasi Cetak ID Card Guru Piket')">
                                                    <i class="bi bi-printer-fill mb-2"></i>
                                                </button>
                                                <form method="POST" action="<?php echo e(url('data-guru-piket/' . $item->id)); ?>"
                                                    data-bs-toggle="modal" id="delete_siswa_form_<?php echo e($item->id); ?>"
                                                    onsubmit="confirmSubmit(event, <?php echo e($item->id); ?>)"
                                                    data-bs-target="#border-less">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-light-danger">
                                                        <i class="bi bi-trash-fill mb-2"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left modal-borderless" id="border-less" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Konfirmasi</h5>
                    <button type="button" class="close rounded-pill" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p>
                        Apakah Anda Yakin Menghapus Data Guru Piket
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-danger" data-bs-dismiss="modal">
                        <i class="bx bx-x d-block d-sm-none"></i>
                        <span class="d-none d-sm-block">Tidak</span>
                    </button>
                    <button type="button" class="btn btn-light-primary ms-1" id="confirm_delete_yes"
                        data-bs-dismiss="modal">
                        <i class="bx bx-check d-block d-sm-none"></i>
                        <span class="d-none d-sm-block">Ya, Hapus</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left" id="aksiLainnyaModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel19">Aksi Lainnya</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-column flex-md-row justify-content-start align-items-center gap-3">
                        <button class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#createBarangModal">
                            <i class="bi bi-plus-square-fill mb-2 me-1"></i>
                            <small>Guru Piket Baru</small>
                        </button>
                        <button class="btn btn-success w-100" data-bs-toggle="modal" data-bs-target="#importBarang">
                            <i class="bi bi-file-earmark-arrow-up-fill mb-2 me-1"></i>
                            <small>Import Data Guru Piket</small>
                        </button>
                        <a class="btn btn-warning w-100" href="<?php echo e(url('/data-guru-piket/export')); ?>" target="_blank">
                            <i class="bi bi-file-earmark-arrow-down-fill mb-2 me-1"></i>
                            <small>Export Data Guru Piket</small>
                        </a>
                        <a class="btn btn-success w-100" href="<?php echo e(url('/data-guru-piket/cetak')); ?>" target="_blank">
                            <i class="bi bi-printer-fill mb-2 me-1"></i>
                            <small>Cetak Semua ID Card</small>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left" id="importBarang" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel19">Import Data Guru Piket</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="<?php echo e(url('data-guru-piket/import')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="container">
                            <div class="mb-3">Import dari file Excel</div>
                            <input type="file" required accept=".xlsx" class="basic-filepond" name="file_siswa"
                                id="file_siswa">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary btn-sm" data-bs-dismiss="modal">
                            <span class="">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1 btn-sm" data-bs-dismiss="modal">
                            <span class="">Import</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left" id="print_preview_modal" tabindex="-1" role="dialog"
        aria-labelledby="confirm_cetak_title" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="confirm_cetak_title">Konfirmasi Cetak QrCode</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex justify-content-center flex-column align-items-center">
                        <div class="d-flex justify-content-center flex-column align-items-center gap-2"
                            id="canvas_container" >
                            <canvas id="print_preview_img" class=""></canvas>
                            <code id="siswa_nis" class="fs-3"></code>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-secondary btn-sm" data-bs-dismiss="modal">
                        <i class="bx bx-x d-block d-sm-none"></i>
                        <span class="">Close</span>
                    </button>
                    <button type="button" class="btn btn-primary ms-1 btn-sm" onclick="donwloadIDCard()"
                        data-bs-dismiss="modal">
                        <i class="bx bx-check d-block d-sm-none"></i>
                        <span class="">Download</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!--Create Data Modal -->
    <div class="modal fade text-left" id="createBarangModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel33" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel33">Tambah Guru Piket</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="<?php echo e(url('/data-guru-piket')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <label for="nis">NIP</label>
                        <div class="form-group">
                            <input required id="nis" name="nis" type="text" class="form-control">
                        </div>
                        <label for="nisn">NISN</label>
                        <div class="form-group">
                            <input required id="nisn" name="nisn" type="text" class="form-control">
                        </div>
                        <label for="nama">Nama Guru Piket</label>
                        <div class="form-group">
                            <input required id="nama" name="nama" type="text" class="form-control">
                        </div>
                        <label for="gender">Gender</label>
                        <div class="form-group">
                            <select required name="gender" id="gender" class="form-control">
                                <option value="" selected disabled>Pilih Gender</option>
                                <option value="L">L</option>
                                <option value="P">P</option>
                            </select>
                        </div>

                        
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">
                            <i class="bx bx-x d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1" data-bs-dismiss="modal">
                            <i class="bx bx-check d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Tambah</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left" id="editBarangModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel33" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel33">Edit Data Guru Piket</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="#" onsubmit="updateGuru()">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" name="edit_id" id="edit_id" value="">
                        <label for="edit_nis">NIS</label>
                        <div class="form-group">
                            <input required id="edit_nis" name="edit_nis" type="text" class="form-control">
                        </div>
                        <label for="edit_nisn">NISN</label>
                        <div class="form-group">
                            <input required id="edit_nisn" name="edit_nisn" type="text" class="form-control">
                        </div>
                        <label for="edit_nama">Nama Guru Piket</label>
                        <div class="form-group">
                            <input required id="edit_nama" name="edit_nama" type="text" class="form-control">
                        </div>
                        <label for="edit_gender">Gender</label>
                        <div class="form-group">
                            <select required name="edit_gender" id="edit_gender" class="form-control">
                                <option value="L">L</option>
                                <option value="P">P</option>
                            </select>
                        </div>

                        
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">
                            <i class="bx bx-x d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1" data-bs-dismiss="modal">
                            <i class="bx bx-check d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Update</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"
        integrity="sha512-BNaRQnYJYiPSqHHDb58B0yaPfCu+Wgds8Gp/gU33kqBtgNS4tSPHuGibyoeqMV/TJlSKda6FXzoEyYGjTe+vXA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <script>
        const canvasContainer = document.getElementById("canvas_container");
        const confirmCetakTitle = document.getElementById("confirm_cetak_title");
        const targetCode = document.getElementById("print_preview_img");
        const siswaNis = document.getElementById('siswa_nis');

        async function generateQRCode(id, title) {
            const siswa = await siswaGet(id);
            await new QRious({
                element: targetCode,
                background: '#ffffff',
                backgroundAlpha: 0,
                foreground: '#1c1c1c',
                foregroundAlpha: 1,
                level: 'H',
                padding: 10,
                size: 192,
                value: siswa.nis,
            });
            siswaNis.innerHTML = `${siswa.nis}`;
        }

        function siswaGet(id) {
            return fetch(`<?php echo e(url('/data-guru-piket/${id}')); ?>`)
                .then(res => res.json())
                .then(result => result)
                .catch(err => console.log(err));
        }

        function donwloadIDCard() {
            html2canvas(canvasContainer).then(function(canvas) {
                const downloadLink = document.createElement('a');
                downloadLink.href = canvas.toDataURL('image/png');
                downloadLink.download = `IDCARD-${siswaName.innerHTML}`;
                downloadLink.click();
                downloadLink.remove();
            });
        }
    </script>

    <script>
        const confirmDeleteYes = document.getElementById("confirm_delete_yes");

        function confirmSubmit(e, id) {
            const deleteBarangForm = document.getElementById(`delete_siswa_form_${id}`);
            e.preventDefault();
            confirmDeleteYes.addEventListener('click', () => {
                deleteBarangForm.submit()
            });
        }
    </script>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>
    <script src="/assets/extensions/filepond/filepond.js"></script>
    <script src="/assets/static/js/pages/filepond.js"></script>

    <script>
        function updateGuru() {
            const data = {
                _token: $("[name='_token']").val(),
                id: $("#edit_id").val(),
                nis: $("#edit_nis").val(),
                nisn: $("#edit_nisn").val(),
                nama: $("#edit_nama").val(),
                gender: $("#edit_gender").val(),
            }
            $.ajax({
                type: "put",
                url: `<?php echo e(url('/data-guru-piket/${data.id}')); ?>`,
                data: data,
                success: function(data) {
                    window.location.reload();
                },
                error: function() {
                    window.location.reload();
                }
            })
        }

        function store() {
            const data = {
                _token: $("[name='_token']").val(),
                nis: $("#nis").val(),
                nisn: $("#nisn").val(),
                nama: $("#nama").val(),
                gender: $("#gender").val(),
            }
            $.ajax({
                type: "post",
                url: "<?php echo e(url('/data-guru-piket')); ?>",
                data: data,
                success: function(data) {
                    // window.location.reload();
                },
                error: function() {
                    // window.location.reload();
                }
            })
        }

        function edit(id) {
            $.ajax({
                type: 'get',
                url: `<?php echo e(url('/data-guru-piket/${id}')); ?>`,
                success: function(data) {
                    $("#edit_id").val(data.id);
                    $("#edit_nis").val(data.nis);
                    $("#edit_nisn").val(data.nisn);
                    $("#edit_nama").val(data.nama);
                    $("#edit_gender").val(data.gender);
                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zona4001/public_html/sobat_telat/resources/views/admin/master/guru_piket/data_guru_piket.blade.php ENDPATH**/ ?>