<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($title); ?></title>
    <link rel="shortcut icon" href="/assets/compiled/svg/clock-history.svg" type="image/x-icon">
    <link rel="stylesheet" href="/assets/compiled/css/app.css">
    <link rel="stylesheet" href="/assets/compiled/css/custom.css">
</head>

<body class="bg-white">
    <div class="mt-4">
        <h3 class="">Laporan Data Keterlambatan Siswa TJKT</h3>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Tanggal Dicetak :</div>
            <span><?php echo e(date('d F Y - H : i')); ?></span>
        </div>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Total Keterlambatan :</div>
            <span><?php echo e($terlambats->count()); ?> Kali</span>
        </div>
        <?php if(!empty(array_filter($filter_result))): ?>
            <div class="d-flex justify-content-start flex-column align-items-start gap-2 mb-2">
                <div class="mb-1">Filter Aktif</div>
                <div class="d-flex justify-content-start align-items-center gap-2">
                    <?php $__currentLoopData = $filter_result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item != null): ?>
                            <?php if($key == 'Kelas'): ?>
                                <span class="badge bg-light-success"><?php echo e($key); ?> : <?php echo e($item->kelas); ?></span>
                            <?php else: ?>
                                <span class="badge bg-light-success"><?php echo e($key); ?> : <?php echo e($item); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>
        <table class="table table-striped">
            <thead class="bg-success">
                <th class="text-white">No</th>
                <th class="text-white">NIS</th>
                <th class="text-white">Nama</th>
                <th class="text-white">Kelas</th>
                <th class="text-white">Masuk Jam Ke</th>
                <th class="text-white">Guru Piket</th>
                <th class="text-white">Alasan</th>
                <th class="text-white">Waktu Terlambat</th>
                <th class="text-white">Status</th>
            </thead>
            <tbody>
                <?php $__currentLoopData = $terlambats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i + 1); ?></td>
                        <td><?php echo e($item->user->nis); ?></td>
                        <td><?php echo e($item->user->nama); ?></td>
                        <td><?php echo e($item->user->kelas->kelas); ?></td>
                        <td>
                            <?php if($item->jam_ke): ?>
                                <?php echo e($item->jam_ke); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($item->disetujui_oleh_id): ?>
                                <?php echo e($item->disetujui_oleh->nama); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($item->keterangan): ?>
                                <?php echo e($item->keterangan); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td><?php echo e(date_format(date_create($item->waktu_terlambat), 'd M Y | H:i')); ?></td>
                        <td class="text-capitalize"><?php echo e($item->status); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
<?php /**PATH /home/zona4001/public_html/sobat_telat/resources/views/admin/transaksi/terlambat/export_terlambat.blade.php ENDPATH**/ ?>