<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Tambah Surat Izin Keluar</title>
    <link rel="shortcut icon" href="/assets/compiled/png/sobattelat.png" type="image/x-icon">
    <link rel="stylesheet" href="/assets/compiled/css/app.css">
    <link rel="stylesheet" href="/assets/compiled/css/custom.css">
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
</head>

<body>
    <div class="text-center bg-success text-white fs-4 mb-4 fw-bold py-3" id="big_title">Formulir Surat Izin Keluar
    </div>
    <section class="row mx-2 my-3">
        <?php echo $__env->make('alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="col-12">
            <div class="row">
                <div class="col-12">
                    <div class="card" id="nis_search">
                        <div class="container px-3 py-3">
                            <div class="fs-6 mb-2">1. &nbsp;Cari Nama atau NIS Siswa</div>
                            <div class="position-relative mb-3">
                                <?php echo csrf_field(); ?>
                                <input type="search" autofocus name="find_siswa" id="find_siswa" autocomplete="off"
                                    class="form-control form-control-lg"required>
                            </div>

                            <div class="position-relative d-flex gap-2 flex-column" id="siswa_find_result">
                                
                            </div>

                            <input type="hidden" value="" name="nis_check" id="nis_check">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card d-none" id="search_result">
                        <div class="container px-3 py-3">
                            <div class="fs-6 mb-2">2. &nbsp;Hasil Pencarian Siswa</div>
                            <div class="container">
                                <div class="d-flex flex-column flex-md-row justify-content-start mb-1">
                                    <span class="fw-bold" style="width: 80px">NIS</span>
                                    <span class="fw-medium" id="nis_result">5939</span>
                                </div>
                                <div class="d-flex flex-column flex-md-row justify-content-start mb-1">
                                    <span class="fw-bold" style="width: 80px">Nama</span>
                                    <span class="fw-medium" id="nama_result">#</span>
                                </div>
                                <div class="d-flex flex-column flex-md-row justify-content-start mb-1">
                                    <span class="fw-bold" style="width: 80px">Kelas</span>
                                    <span class="fw-medium" id="kelas_result">#</span>
                                </div>
                                <div class="d-flex flex-column flex-md-row justify-content-start mb-1">
                                    <span class="fw-bold" style="width: 80px">Gender</span>
                                    <span class="fw-medium" id="gender_result">#</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <form action="<?php echo e(url('send-ijin')); ?>" method="POST" id="send_form">
                    <?php echo csrf_field(); ?>
                    <div class="col-12">
                        <div class="card" id="jam_pembelajaran">
                            <div class="container px-3 py-3">
                                <div class="fs-6 mb-2">3. &nbsp;Siswa Ijin Jam Pembelajaran Ke</div>
                                <select required name="jam_ke" id="jam_ke" class="form-control form-control-lg">
                                    <option value="" selected disabled>Pilih Jam Pembelajaran</option>
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                    <option value="6">6</option>
                                    <option value="7">7</option>
                                    <option value="8">8</option>
                                    <option value="9">9</option>
                                    <option value="10">10</option>
                                    <option value="11">11</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card" id="guru_mapel">
                            <div class="container px-3 py-3">
                                <div class="fs-6 mb-2">4. &nbsp;Guru Mapel Sekarang</div>
                                <select required name="guru_id" id="guru_id" class="form-control form-control-lg">
                                    <option value="" selected disabled>Pilih Guru Mapel</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="decision" id="decision">
                    <input type="hidden" name="nis" id="nis_send">
                    <div class="row">
                        <div class="col-12">
                            <div class="card d-none" id="keterangan_container">
                                <div class="container px-3 py-3">
                                    <div class="fs-6 mb-2">5. &nbsp;Alasan Siswa Ijin</div>
                                    <textarea placeholder="Singkat Saja" required name="keterangan" id="keterangan" cols="30" rows="3"
                                        class="form-control form-control-lg"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row d-none" id="send_container">
                        <div class="col-12 mb-3 col-md-4 mb-md-0">
                            <div class="d-flex justify-content-center align-items-center">
                                <button value="save_only" id="save_only"
                                    class="btn btn-success btn-lg w-100 d-flex justify-content-center align-items-center gap-3">
                                    <i class="bi bi-send-check-fill mb-3"></i>
                                    <span class="fw-bold">Buat Surat</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
    </section>

    <script src="/assets/compiled/js/app.js"></script>
    <script src="/assets/extensions/toastify-js/src/toastify.js"></script>
    <script src="/assets/static/js/components/dark.js"></script>
    <script src="/assets/extensions/jquery/jquery.min.js"></script>

    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.2/anime.min.js"
        integrity="sha512-aNMyYYxdIxIaot0Y1/PLuEu3eipGCmsEUBrUq+7aVyPGMFH8z0eTP0tkqAvv34fzN6z+201d3T8HPb1svWSKHQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script>
            if (localStorage.getItem('theme') == 'dark') {
                localStorage.setItem('theme', 'light');
            }
        </script>
    <script>
        let first = true;
        anime({
            targets: ['#nis_search', '#search_result', '#jam_pembelajaran', '#guru_mapel', '#keterangan_container',
                '#send_container'
            ],
            scaleY: 0,
            duration: 0,
        });
        anime({
            targets: '#big_title',
            translateY: -200,
            duration: 0,
        });

        window.onload = () => {
            setTimeout(() => {
                anime({
                    targets: '#big_title',
                    translateY: 0,
                    duration: 1000,
                    easing: 'easeInOutExpo',
                });
                anime({
                    targets: '#nis_search',
                    scaleY: 1,
                    duration: 300,
                    easing: 'easeInOutExpo',
                });
            }, 150)
            getGuruMapel();
        }

        function getGuruMapel() {
            $.ajax({
                type: 'get',
                url: "<?php echo e(url('/guru-mapel-list')); ?>",
                success: function(data) {
                    data.user.forEach((item) => {
                        const opt = document.createElement('option');
                        opt.value = item.id;
                        opt.innerHTML = item.nama;
                        $("#guru_id").append(opt);
                    })
                }
            })
        }

        function nisFound(first) {
            anime({
                targets: '#search_result',
                scaleY: 0,
                duration: 350,
                easing: 'easeInOutExpo',
            });
            setTimeout(() => {
                anime({
                    targets: '#search_result',
                    scaleY: 1,
                    duration: 500,
                    easing: 'easeInOutExpo',
                    delay: 0
                });
                anime({
                    targets: '#jam_pembelajaran',
                    scaleY: 1,
                    duration: 500,
                    easing: 'easeInOutExpo',
                    delay: 150
                });
                anime({
                    targets: '#guru_mapel',
                    scaleY: 1,
                    duration: 500,
                    easing: 'easeInOutExpo',
                    delay: 300
                });
                anime({
                    targets: '#keterangan_container',
                    scaleY: 1,
                    duration: 500,
                    easing: 'easeInOutExpo',
                    delay: 450
                });
                anime({
                    targets: '#send_container',
                    scaleY: 1,
                    duration: 500,
                    easing: 'easeInOutExpo',
                    delay: 600
                });
            }, first ? 250 : 500)
        }
    </script>

    <script>
        let findSiswa = document.getElementById('find_siswa');
        let sendForm = document.getElementById('send_form');
        let nisCheck = document.getElementById('nis_check');

        findSiswa.addEventListener('keyup', findSiswaorNIS);
        sendForm.addEventListener('submit', beforeSubmit);

        function findSiswaorNIS() {
            if (findSiswa.value != "" && findSiswa.value.length >= 4) {
                $("#siswa_find_result").empty();
                let buttonLoad =
                    `<button class="btn btn-light-warning w-100 fw-semibold" id="btn_load_find">Mencari...</button>`;
                $("#siswa_find_result").append(buttonLoad);
                setTimeout(() => {
                    $.ajax({
                        type: 'get',
                        url: "<?php echo e(url('/find-siswa-nis')); ?>",
                        data: {
                            search: findSiswa.value,
                        },
                        success: function(data) {
                            $("#siswa_find_result").empty();
                            if (data.length > 0) {
                                data.forEach((item, index) => {
                                    let button =
                                        `<button id="${index}-res" class="btn btn-light-success w-100 fw-semibold text-start" value="${item.nama}" onclick="selectedSiswa('${item.nis}', '${index}-res')">${item.nis} - ${item.nama}</button>`;
                                    $("#siswa_find_result").append(button);
                                })
                            } else {
                                let button =
                                    `<button class="btn btn-light-danger w-100 fw-semibold">Siswa Tidak Ditemukan</button>`;
                                $("#siswa_find_result").append(button);
                            }
                        },
                        error: function(xhr, status, err) {
                            console.log(err);
                        }
                    })
                }, 750)
            } else {
                $("#siswa_find_result").empty();
            }
        }

        function selectedSiswa(nis, id) {
            let btn = document.getElementById(`${id}`);
            nisCheck.value = nis;
            $("#find_siswa").val(btn.value);
            getNIS();
            $("#siswa_find_result").empty();
        }

        function getNIS() {
            if (nisCheck.value !== document.getElementById('nis_send').value) {
                $.ajax({
                    type: 'get',
                    url: "<?php echo e(url('/check-nis')); ?>",
                    data: {
                        nis: nisCheck.value
                    },
                    success: function(result) {
                        nisFound(first);
                        first = false;
                        $("#search_result").removeClass('d-none');
                        $("#keterangan_container").removeClass('d-none');
                        $("#send_container").removeClass('d-none');
                        $("#nis_send").val(result.nis);
                        //
                        setTimeout(() => {
                            $("#nis_result").html(result.nis);
                            $("#nama_result").html(result.nama);
                            $("#kelas_result").html(result.kelas.kelas);
                            $("#gender_result").html(result.gender);
                        }, 500)
                    },
                    error: function(xhr, status, err) {
                        if (window.innerWidth <= 768) {
                            toastResult("top", "center", xhr.responseJSON, "failed")
                        } else {
                            toastResult("bottom", "right", xhr.responseJSON, "failed")
                        }
                    }
                })
            } else {
                if (window.innerWidth <= 768) {
                    toastResult("top", "center", "Siswa Sudah Ditemukan", "failed")
                } else {
                    toastResult("bottom", "right", "Siswa Sudah Ditemukan", "failed")
                }
            }
        }

        function beforeSubmit(event) {
            event.preventDefault();
            let decision = event.submitter.value;
            $("#decision").val(decision);
            $("#save_only").prop("disabled", true);
            $("#save_only").html('Loading')
            setTimeout(() => {
                $("#send_form").submit();
            }, 100)
        }
    </script>
</body>

</html>
<?php /**PATH C:\laragon\www\sobat_telat\resources\views/admin/transaksi/ijin/tambah_ijin.blade.php ENDPATH**/ ?>