<?php $__env->startSection('content_admin'); ?>
    <style>
        #export_btn:disabled::before {
            position: absolute;
            content: '';
            width: 150%;
            height: 4px;
            background-color: #1c1c1c;
            rotate: -14deg;
        }

        #export_btn:disabled::after {
            position: absolute;
            content: '';
            width: 150%;
            height: 4px;
            background-color: #1c1c1c;
            rotate: -30deg;
        }

        .count-data{
            left: 0;
        }

        @media only screen and (min-width: 768px) {
            .count-data{
                left: 1.4em;
            }
        }
    </style>
    <div class="row">
        <?php if(Session::has('targetUrl')): ?>
            <a href="<?php echo e(Session::get('targetUrl')); ?>" id="target_url" target="_blank"></a>
            <script>
                let a = document.getElementById('target_url').click();
            </script>
        <?php endif; ?>
        <div class="col-12">
            <?php echo $__env->make('alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-header d-flex position-relative flex-column">
                    <div class="d-flex justify-content-between gap-3 flex-md-row flex-column align-items-center">
                        <h4 class="fs-6 d-md-none d-block">Data Keterlambatan Siswa</h4>
                        <h4 class="d-none d-md-block">Data Keterlambatan Siswa</h4>
                        <div class="d-flex justify-content-between align-items-center gap-3">
                            <button id="clear_filter" onclick="window.location.href = '/data-terlambat'"
                                class="btn btn-light-danger d-none d-flex justify-content-center align-items-center">
                                <i class="bi bi-x-octagon-fill mb-2 me-md-2"></i>
                                <small class="d-none d-md-block">Bersihkan Filter</small>
                            </button>
                            <button id="export_btn" onclick="readyExport()" <?php if($terlambats->count() == 0): echo 'disabled'; endif; ?>
                                class="btn position-relative overflow-hidden btn-warning d-flex justify-content-center align-items-center">
                                <i class="bi bi-file-earmark-arrow-down-fill mb-2 me-md-2"></i>
                                <small class="d-none d-md-block">Export</small>
                            </button>
                            <button onclick="readyFn()"
                                class="btn btn-primary d-flex justify-content-center align-items-center"
                                data-bs-toggle="modal" data-bs-target="#filterModal">
                                <i class="bi bi-funnel-fill mb-2 me-md-2"></i>
                                <small class="d-none d-md-block">Filter</small>
                            </button>
                        </div>
                    </div>
                    <div class="position-absolute count-data w-100 d-flex d-md-block justify-content-center"
                        style="bottom: -1em">
                        <div class="badge bg-light-primary border-4 border px-2 py-1">
                            Total <?php echo e($terlambats->count()); ?> Surat Terlambat
                        </div>
                    </div>
                    <?php if($result_filters != null): ?>
                        <div class="row mt-3">
                            <?php $__currentLoopData = $result_filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 col-12 my-1">
                                    <div
                                        class="badge bg-light-primary position-relative px-3 py-2 d-flex justify-content-start align-items-center gap-2">
                                        <?php if($key == 'nis_siswa'): ?>
                                            <i class="bi bi-person-fill"></i>
                                        <?php elseif($key == 'kelas'): ?>
                                            <i class="bi bi-person-workspace"></i>
                                        <?php elseif($key == 'date_range'): ?>
                                            <i class="bi bi-calendar-range"></i>
                                        <?php elseif($key == 'status'): ?>
                                            <i class="bi bi-activity"></i>
                                        <?php elseif($key == 'keterangan'): ?>
                                            <i class="bi bi-justify"></i>
                                        <?php endif; ?>
                                        <div class=""><?php echo e($item); ?></div>
                                        <div class="position-absolute top-0 end-0 mt-2 me-3"
                                            style="z-index: 10; cursor: pointer !important"
                                            onclick="removeParams('<?php echo e($key); ?>')">
                                            <i class="bi bi-x-circle-fill"></i>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $terlambats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 my-2">
                        <div class="card shadow p-3 position-relative overflow-hidden mb-2">
                            <div class="d-flex justify-content-between">
                                <div class="d-flex flex-row justify-content-between w-100 align-items-start">
                                    <div class="d-flex gap-3 align-items-start">
                                        <div class="">
                                            <?php if($item->status == 'disetujui'): ?>
                                                <i class="bi bi-check-circle-fill text-success fs-3 mb-2"></i>
                                            <?php elseif($item->status == 'pending'): ?>
                                                <i class="bi bi-hourglass-split fs-3 text-primary mb-2"></i>
                                            <?php else: ?>
                                                <i class="bi bi-ban-fill fs-3 mb-2 text-danger"></i>
                                            <?php endif; ?>
                                        </div>
                                        <div class="c-details">
                                            <h6 class="mb-0"><?php echo e($item->user->nama); ?></h6> <span><?php echo e($item->user->nis); ?> -
                                                <?php echo e($item->user->kelas->kelas); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-4">
                                <h4 class="fs-4"><?php echo e($item->keterangan); ?></h4>
                                <div class="mt-4 d-flex justify-content-between align-items-start w-100">
                                    <div class="">
                                        <div class="d-flex justify-content-start-align-items-start gap-2">
                                            <i class="bi bi-calendar-week"></i>
                                            <span><?php echo e(date_format(date_create($item->waktu_terlambat), 'd M Y - H:i')); ?></span>
                                        </div>
                                        <div class="d-flex mb-4 justify-content-start-align-items-start gap-2">
                                            <i class="bi bi-clock mb-2"></i>
                                            <span>Jam Ke <?php echo e($item->jam_ke); ?></span>
                                        </div>
                                        <div class="d-flex justify-content-start-align-items-start gap-2">
                                            <i class="bi bi-textarea mb-2"></i>
                                            <span>
                                                <?php if($item->disetujui_oleh_id): ?>
                                                    <?php echo e($item->disetujui_oleh->nama); ?>

                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="d-flex flex-column gap-3">
                                        <?php if($item->status == 'disetujui'): ?>
                                            <button
                                                onclick="window.open('<?php echo e(url('cetak-terlambat/' . $item->id)); ?>', '_blank')"
                                                class="btn btn-light-warning btn-lg">
                                                <i class="bi bi-printer-fill mb-2"></i>
                                            </button>
                                        <?php elseif($item->status == 'pending'): ?>
                                            <button type="button" data-bs-toggle="modal"
                                                onclick="readyApprove(<?php echo e($item->id); ?>)" data-bs-target="#approveModal"
                                                class="btn btn-light-primary btn-lg">
                                                <i class="bi bi-patch-question-fill mb-2"></i>
                                            </button>
                                        <?php endif; ?>
                                        <button onclick="setIdToDelete(<?php echo e($item->id); ?>)" data-bs-toggle="modal"
                                            data-bs-target="#deleteModal" class="btn h-100 btn-light-danger btn-lg">
                                            <i class="bi bi-trash-fill mb-2"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel19">Filter Data</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="<?php echo e(url('data-terlambat')); ?>" method="GET">
                    <div class="modal-body">
                        <div class="accordion accordion-flush" id="accordionFlushExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingOne">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseOne" aria-expanded="false"
                                        aria-controls="flush-collapseOne">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-2 align-items-center">
                                            <div>Berdasarkan Kelas</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_kelas"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseOne" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <select name="kelas_id" id="kelas_id" class="form-control form-control-lg">
                                                
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseTwo" aria-expanded="false"
                                        aria-controls="flush-collapseTwo">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-3 align-items-center">
                                            <div>Berdasarkan Rentang Tanggal</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_tanggal"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseTwo" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingTwo" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <div class="d-flex justify-content-start gap-2 align-items-center">
                                                <input type="text" readonly placeholder="Tanggal Awal"
                                                    autocomplete="off" name="start_date" id="start_date"
                                                    class="form-control form-control-lg">
                                                <span>-</span>
                                                <input type="text" readonly placeholder="Tanggal Akhir"
                                                    name="end_date" autocomplete="off" id="end_date"
                                                    class="form-control form-control-lg">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseThree" aria-expanded="false"
                                        aria-controls="flush-collapseThree">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-2 align-items-center">
                                            <div>Berdasarkan NIS Siswa</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_siswa"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseThree" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <input type="text" maxlength="4" pattern="[0-9]{4}"
                                                title="Hanya 4 Angka Untuk NIS" placeholder="NIS Siswa"
                                                autocomplete="off" name="nis_siswa" id="nis_siswa"
                                                class="form-control form-control-lg">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingFour">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseFour" aria-expanded="false"
                                        aria-controls="flush-collapseFour">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-2 align-items-center">
                                            <div>Berdasarkan Alasan Terlambat</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_keterangan"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseFour" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingFour" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <input type="text" placeholder="Kata kunci" name="keterangan"
                                                id="keterangan" class="form-control form-control-lg">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingFive">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseFive" aria-expanded="false"
                                        aria-controls="flush-collapseFive">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-2 align-items-center">
                                            <div>Berdasarkan Status</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_status"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseFive" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingFive" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <select name="status" id="status" class="form-control form-control-lg">
                                                <option value="" selected disabled>Pilih Status</option>
                                                <option value="pending">Pending</option>
                                                <option value="disetujui">Disetujui</option>
                                                <option value="ditolak">Ditolak</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">
                            <span class="">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1" data-bs-dismiss="modal">
                            <span class="">Filter</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left modal-borderless" id="deleteModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Konfirmasi</h5>
                    <button type="button" class="close rounded-pill" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p>
                        Apakah Anda Yakin Menghapus Data Keterlambatan Siswa
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-danger" data-bs-dismiss="modal">
                        <span class="">Tidak</span>
                    </button>
                    <form action="<?php echo e(url('delete-terlambat')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <input type="hidden" value="" name="delete_id" id="delete_id">
                        <button type="submit" class="btn btn-light-primary ms-1" id="confirm_delete_yes"
                            data-bs-dismiss="modal">
                            <span class="">Ya, Hapus</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left modal-borderless" id="approveModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Konfirmasi Persetujuan Surat</h5>
                    <button type="button" class="close rounded-pill" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p>
                        Keputusan Anda untuk setuju atau menolak dan surat akan langsung di cetak
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-danger" data-bs-dismiss="modal">
                        <span class="">Batalkan</span>
                    </button>
                    <form action="<?php echo e(url('approve-terlambat')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <input type="hidden" value="" name="approve_id" id="approve_id">
                        <button type="submit" value="ditolak" name="decision" class="btn btn-light-warning ms-1"
                            data-bs-dismiss="modal">
                            <span class="">Tidak, Tolak Saja</span>
                        </button>
                        <button type="submit" value="disetujui" name="decision" class="btn btn-light-primary ms-1"
                            data-bs-dismiss="modal">
                            <span class="">Ya, Setujui</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>

    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/litepicker/2.0.12/litepicker.js"
        integrity="sha512-ZbnsrTCJAJWynwgi3ndt7jcjwrJfHNzUh/mZakBRhZG8lYgMVtZLxY2CG4GuONoER9E8iiuupt4fnrNfXy+aGA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/litepicker/2.0.12/plugins/mobilefriendly.min.js"
        integrity="sha512-oGLJsXoz/9rjlOQ+iUaOZo/S0IOlN35P/Iv5JdYAUP3TaW2hg0FvhsW3loRAbET59xFCSAwnsc7i9ULVnZuAtQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        const picker = new Litepicker({
            element: document.getElementById('start_date'),
            elementEnd: document.getElementById('end_date'),
            singleMode: false,
            allowRepick: true,
            plugins: ['mobilefriendly'],
            tooltipText: {
                one: 'Rentang Hari',
                other: 'Rentang Hari'
            },
            tooltipNumber: (totalDays) => {
                return totalDays - 1;
            },
        })
    </script>

    <script>
        function removeParams(param) {
            const params = new URLSearchParams(window.location.search);
            if (param == "date_range") {
                params.delete('start_date');
                params.delete('end_date');
            } else if (param == "kelas") {
                params.delete('kelas_id')
            } else {
                params.delete(param);
            }
            const newURL = `${window.location.origin}${window.location.pathname}?${params.toString()}`;
            window.location.href = newURL;
        }
    </script>

    <script>
        window.onload = () => {
            let params = new URLSearchParams(window.location.search);
            let select = document.getElementById('kelas_id');
            if (params.get('kelas_id') || params.get('start_date') || params.get('end_date') || params.get(
                    'nis_siswa') || params.get('keterangan') || params.get('status')) {
                $("#clear_filter").removeClass('d-none');
            }
        }

        function readyFn() {
            kelasReady();
            tanggalReady();
            nisReady();
            keteranganReady();
            statusReady();
        }

        function kelasReady() {
            // Params
            let params = new URLSearchParams(window.location.search);

            let kelasSelect = document.getElementById('kelas_id');
            if (kelasSelect.querySelector('option') == null) {
                const optDefault = document.createElement('option');
                optDefault.value = "Fara";
                optDefault.innerHTML = "Pilih Kelas";
                $("#kelas_id").append(optDefault);
                $("#kelas_id").find('option[value="Fara"]').prop('disabled', true);
                $.ajax({
                    type: 'get',
                    url: "<?php echo e(url('/kelas?type=siswa')); ?>",
                    success: function(data) {
                        data.forEach((item) => {
                            const opt = document.createElement('option');
                            opt.value = item.id;
                            opt.innerHTML = item.kelas;
                            $("#kelas_id").append(opt);
                        })
                        if (params.get('kelas_id')) {
                            $("#active_filter_kelas").removeClass('d-none');
                            $("#kelas_id").val(params.get('kelas_id'));
                        }
                    }
                })
            }
        }

        function tanggalReady() {
            // Params
            let params = new URLSearchParams(window.location.search);
            if (params.get('start_date') && params.get('end_date')) {
                $("#active_filter_tanggal").removeClass('d-none');
                $("#start_date").val(params.get('start_date'))
                $("#end_date").val(params.get('end_date'))
            }
        }

        function nisReady() {
            let params = new URLSearchParams(window.location.search);
            if (params.get('nis_siswa')) {
                $("#active_filter_siswa").removeClass('d-none');
                $("#nis_siswa").val(params.get('nis_siswa'))
            }
        }

        function keteranganReady() {
            let params = new URLSearchParams(window.location.search);
            if (params.get('keterangan')) {
                $("#active_filter_keterangan").removeClass('d-none');
                $("#keterangan").val(params.get('keterangan'))
            }
        }

        function statusReady() {
            let params = new URLSearchParams(window.location.search);
            if (params.get('status')) {
                $("#active_filter_status").removeClass('d-none');
                $("#status").val(params.get('status'))
            }
        }

        function getParams() {
            let params = new URLSearchParams(window.location.search);
            let sendParams = [];
            params.forEach((val, key) => {
                sendParams[key] = val;
            });
            return sendParams;
        }

        function readyExport() {
            let redirectURL = new URL(`${window.location.origin}/export-terlambat`);
            let paramList = getParams();
            for (var key in paramList) {
                if (paramList.hasOwnProperty(key)) {
                    redirectURL.searchParams.set(key, paramList[key]);
                }
            }
            window.open(redirectURL.toString(), '_blank');
        }

        function setIdToDelete(id) {
            $("#delete_id").val(id);
        }

        function readyApprove(id) {
            $("#approve_id").val(id);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sobat_telat\resources\views/admin/transaksi/terlambat/data_terlambat.blade.php ENDPATH**/ ?>