<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\SiswaController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\GuruPiketController;
use App\Http\Controllers\IjinTransaksiController;
use App\Http\Controllers\KelasController;
use App\Http\Controllers\TransaksiController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Guest or Siswa Access
Route::middleware('guest')->group(function () {
    // Root
    Route::get('/', function () {
        return view('guest.welcome');
    });
    Route::get('tambah-terlambat', [TransaksiController::class, 'tambah']);
    Route::post('send-terlambat', [TransaksiController::class, 'store']);

    Route::get('tambah-ijin', [IjinTransaksiController::class, 'tambah']);
    Route::post('send-ijin', [IjinTransaksiController::class, 'store']);

    // Ajax Request
    Route::get('check-nis', [TransaksiController::class, 'checkNis']);
    Route::get('find-siswa-nis', [TransaksiController::class, 'findSiswaNis']);
    Route::get('/guru-mapel-list', [KelasController::class, 'guruList']);

    // Login for Guest
    Route::get('/login', [AuthController::class, 'index'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
});

Route::middleware('auth')->group(function () {
    Route::get('/admin', [DashboardController::class, 'index']);

    Route::post('/logout', [AuthController::class, 'logout']);

    // Data Siswa Route
    Route::get('data-siswa', [SiswaController::class, 'index']);
    Route::middleware(['AdminAccess'])->group(function () {
        Route::get('data-siswa/cetak', [SiswaController::class, 'cetak']);
        Route::post('data-siswa/import', [SiswaController::class, 'importData']);
        Route::get('data-siswa/export', [SiswaController::class, 'exportData']);
        Route::post('data-siswa', [SiswaController::class, 'store']);
        Route::delete('data-siswa/{id}', [SiswaController::class, 'destroy']);
        Route::get('data-siswa/{id}', [SiswaController::class, 'show']);
        Route::put('data-siswa/{id}', [SiswaController::class, 'update']);
        Route::post('data-siswa/update-kelas', [SiswaController::class, 'updateKelas']);
    });

    // Data Guru Piket Route
    Route::middleware(['AdminAccess'])->group(function () {
        Route::get('data-guru-piket', [GuruPiketController::class, 'index']);
        Route::get('data-guru-piket/cetak', [GuruPiketController::class, 'cetak']);
        Route::post('data-guru-piket/import', [GuruPiketController::class, 'importData']);
        Route::get('data-guru-piket/export', [GuruPiketController::class, 'exportData']);
        Route::post('data-guru-piket', [GuruPiketController::class, 'store']);
        Route::delete('data-guru-piket/{id}', [GuruPiketController::class, 'destroy']);
        Route::get('data-guru-piket/{id}', [GuruPiketController::class, 'show']);
        Route::put('data-guru-piket/{id}', [GuruPiketController::class, 'update']);
    });

    // Data Terlambat (Transaksi) Route
    Route::get('data-terlambat', [TransaksiController::class, 'index']);
    Route::get('cetak-terlambat/{id}', [TransaksiController::class, 'print']);
    Route::get('export-terlambat', [TransaksiController::class, 'export']);
    Route::delete('delete-terlambat', [TransaksiController::class, 'destroy']);
    Route::put('approve-terlambat', [TransaksiController::class, 'approve']);

    // Data Ijin (Transaksi) Route
    Route::get('data-ijin', [IjinTransaksiController::class, 'index']);
    Route::get('cetak-ijin/{id}', [IjinTransaksiController::class, 'print']);
    Route::get('export-ijin', [IjinTransaksiController::class, 'export']);
    Route::delete('delete-ijin', [IjinTransaksiController::class, 'destroy']);
    Route::put('approve-ijin', [IjinTransaksiController::class, 'approve']);

    // AJAX Request Routes
    Route::get('kelas', [KelasController::class, 'index']);
    // Route::get('check-nis', [TransaksiController::class, 'checkNis']);
    // Route::get('find-siswa-nis', [TransaksiController::class, 'findSiswaNis']);
    // Route::get('/guru-mapel-list', [KelasController::class, 'guruList']);

    // UserLogged Routes
    Route::get('/my-profile', [AuthController::class, 'whoLogin']);
    Route::get('/check-pw', [AuthController::class, 'checkPw']);
    Route::put('/new-pw', [AuthController::class, 'newPw']);
    Route::put('/my-profile', [AuthController::class, 'update']);
});
