<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $title }}</title>
    <link rel="shortcut icon" href="/assets/compiled/svg/clock-history.svg" type="image/x-icon">
    <link rel="stylesheet" href="/assets/compiled/css/app.css">
    <link rel="stylesheet" href="/assets/compiled/css/custom.css">
</head>

<body class="bg-white">
    <div class="mt-4">
        <h3 class="">Laporan Data Surat Izin Siswa TJKT</h3>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Tanggal Dicetak :</div>
            <span>{{ date('d F Y - H : i') }}</span>
        </div>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Total Surat Izin :</div>
            <span>{{ $ijins->count() }} Kali</span>
        </div>
        @if (!empty(array_filter($filter_result)))
            <div class="d-flex justify-content-start flex-column align-items-start gap-2 mb-2">
                <div class="mb-1">Filter Aktif</div>
                <div class="d-flex justify-content-start align-items-center gap-2">
                    @foreach ($filter_result as $key => $item)
                        @if ($item != null)
                            @if ($key == 'Kelas')
                                <span class="badge bg-light-success">{{ $key }} : {{ $item->kelas }}</span>
                            @else
                                <span class="badge bg-light-success">{{ $key }} : {{ $item }}</span>
                            @endif
                        @endif
                    @endforeach
                </div>
            </div>
        @endif
        <table class="table table-striped">
            <thead class="bg-success">
                <th class="text-white">No</th>
                <th class="text-white">NIS | Kelas</th>
                <th class="text-white">Nama</th>
                <th class="text-white">Guru Mapel</th>
                <th class="text-white">Guru Piket</th>
                <th class="text-white">Izin Jam Ke</th>
                <th class="text-white">Alasan</th>
                <th class="text-white">Waktu Ijin</th>
                <th class="text-white">Status</th>
            </thead>
            <tbody>
                @foreach ($ijins as $i => $item)
                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $item->user->nis }} | {{ $item->user->kelas->kelas }}</td>
                        <td>{{ $item->user->nama }}</td>
                        <td>{{ $item->guru->nama }}</td>
                        
                        <td>
                            @if ($item->disetujui_oleh_id)
                                {{ $item->disetujui_oleh->nama }}
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            @if ($item->jam_ke)
                                {{ $item->jam_ke }}
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            @if ($item->keterangan)
                                {{ $item->keterangan }}
                            @else
                                -
                            @endif
                        </td>
                        <td>{{ date_format(date_create($item->waktu_ijin), 'd M Y | H:i') }}</td>
                        <td class="text-capitalize">{{ $item->status }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
