@extends('admin.template')
@section('content_admin')
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">
    <style>
        #export_btn:disabled::before {
            position: absolute;
            content: '';
            width: 150%;
            height: 4px;
            background-color: #1c1c1c;
            rotate: -14deg;
        }

        #export_btn:disabled::after {
            position: absolute;
            content: '';
            width: 150%;
            height: 4px;
            background-color: #1c1c1c;
            rotate: -30deg;
        }
        .count-data{
            left: 0;
        }

        @media only screen and (min-width: 768px) {
            .count-data{
                left: 1.4em;
            }
        }
    </style>
    <div class="row">
        @if (Session::has('targetUrl'))
            <a href="{{ Session::get('targetUrl') }}" id="target_url" target="_blank"></a>
            <script>
                let a = document.getElementById('target_url').click();
            </script>
        @endif
        <div class="col-12">
            @include('alert')
            <div class="card">
                <div class="card-header d-flex flex-column">
                    <div class="d-flex flex-md-row flex-column gap-3 justify-content-between align-items-center">
                        <h4 class="fs-6 d-md-none d-block">Data Surat Ijin Siswa</h4>
                        <h4 class="d-none d-md-block">Data Surat Ijin Siswa</h4>
                        <div class="d-flex justify-content-between align-items-center gap-3">
                            <button id="clear_filter" onclick="window.location.href = '/data-ijin'"
                                class="btn btn-light-danger d-none d-flex justify-content-center align-items-center">
                                <i class="bi bi-x-octagon-fill mb-2 me-md-2"></i>
                                <small class="d-none d-md-block">Bersihkan Filter</small>
                            </button>
                            <button id="export_btn" onclick="readyExport()" @disabled($ijins->count() == 0)
                                class="btn position-relative overflow-hidden btn-warning d-flex justify-content-center align-items-center">
                                <i class="bi bi-file-earmark-arrow-down-fill mb-2 me-md-2"></i>
                                <small class="d-none d-md-block">Export</small>
                            </button>
                            <button onclick="readyFn()"
                                class="btn btn-primary d-flex justify-content-center align-items-center"
                                data-bs-toggle="modal" data-bs-target="#filterModal">
                                <i class="bi bi-funnel-fill mb-2 me-md-2"></i>
                                <small class="d-none d-md-block">Filter</small>
                            </button>
                        </div>
                    </div>
                    <div class="position-absolute count-data w-100 d-flex d-md-block justify-content-center"
                    style="bottom: -1em">
                    <div class="badge bg-light-success border-4 border px-2 py-1">
                        Total {{ $ijins->count() }} Surat Izin
                    </div>
                </div>
                    @if ($result_filters != null)
                        <div class="row mt-3">
                            @foreach ($result_filters as $key => $item)
                                <div class="col-md-4 col-12 my-1">
                                    <div
                                        class="badge bg-light-success position-relative px-3 py-2 d-flex justify-content-start align-items-center gap-2">
                                        @if ($key == 'nis_siswa')
                                            <i class="bi bi-person-fill"></i>
                                        @elseif ($key == 'kelas')
                                            <i class="bi bi-person-workspace"></i>
                                        @elseif ($key == 'date_range')
                                            <i class="bi bi-calendar-range"></i>
                                        @elseif ($key == 'status')
                                            <i class="bi bi-activity"></i>
                                        @elseif ($key == 'keterangan')
                                            <i class="bi bi-justify"></i>
                                        @endif
                                        <div class="">{{ $item }}</div>
                                        <div class="position-absolute top-0 end-0 mt-2 me-3"
                                            style="z-index: 10; cursor: pointer !important"
                                            onclick="removeParams('{{ $key }}')">
                                            <i class="bi bi-x-circle-fill"></i>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
            <div class="row">
                @foreach ($ijins as $i => $item)
                    <div class="col-md-4 my-2">
                        <div class="card shadow p-3 position-relative overflow-hidden mb-2">
                            <div class="d-flex justify-content-between">
                                <div class="d-flex flex-row justify-content-between w-100 align-items-start">
                                    <div class="d-flex gap-3 align-items-start">
                                        <div class="">
                                            @if ($item->status == 'disetujui')
                                                <i class="bi bi-check-circle-fill text-success fs-3 mb-2"></i>
                                            @elseif ($item->status == 'pending')
                                                <i class="bi bi-hourglass-split fs-3 text-primary mb-2"></i>
                                            @else
                                                <i class="bi bi-ban-fill fs-3 mb-2 text-danger"></i>
                                            @endif
                                        </div>
                                        <div class="c-details">
                                            <h6 class="mb-0">{{ $item->user->nama }}</h6> <span>{{ $item->user->nis }} -
                                                {{ $item->user->kelas->kelas }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-4">
                                <h4 class="fs-4">{{ $item->keterangan }}</h4>
                                <div class="mt-4 d-flex justify-content-between align-items-start w-100">
                                    <div class="">
                                        <div class="d-flex justify-content-start-align-items-start gap-2">
                                            <i class="bi bi-calendar-week"></i>
                                            <span>{{ date_format(date_create($item->waktu_ijin), 'd M Y - H:i') }}</span>
                                        </div>
                                        <div class="d-flex mb-4 justify-content-start-align-items-start gap-2">
                                            <i class="bi bi-clock mb-2"></i>
                                            <span>Jam Ke {{ $item->jam_ke }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start-align-items-start gap-2">
                                            <i class="bi bi-person-workspace mb-2"></i>
                                            <span>
                                                @if ($item->guru_id)
                                                    {{ $item->guru->nama }}
                                                @else
                                                    -
                                                @endif
                                            </span>
                                        </div>
                                        <div class="d-flex justify-content-start-align-items-start gap-2">
                                            <i class="bi bi-textarea mb-2"></i>
                                            <span>
                                                @if ($item->disetujui_oleh_id)
                                                    {{ $item->disetujui_oleh->nama }}
                                                @else
                                                    -
                                                @endif
                                            </span>
                                        </div>
                                    </div>
                                    <div class="d-flex flex-column gap-3">
                                        @if ($item->status == 'disetujui')
                                            <button onclick="window.open('{{ url('cetak-ijin/' . $item->id) }}', '_blank')"
                                                class="btn btn-light-warning btn-lg">
                                                <i class="bi bi-printer-fill mb-2"></i>
                                            </button>
                                        @elseif ($item->status == 'pending')
                                            <button type="button" data-bs-toggle="modal"
                                                onclick="readyApprove({{ $item->id }})" data-bs-target="#approveModal"
                                                class="btn btn-light-primary btn-lg">
                                                <i class="bi bi-patch-question-fill mb-2"></i>
                                            </button>
                                        @endif
                                        <button onclick="setIdToDelete({{ $item->id }})" data-bs-toggle="modal"
                                            data-bs-target="#deleteModal" class="btn h-100 btn-light-danger btn-lg">
                                            <i class="bi bi-trash-fill mb-2"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    {{-- Delete Modals --}}
    <div class="modal fade text-left modal-borderless" id="deleteModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Konfirmasi</h5>
                    <button type="button" class="close rounded-pill" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p>
                        Apakah Anda Yakin Menghapus Data Perizinan Siswa
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-danger" data-bs-dismiss="modal">
                        <span class="">Tidak</span>
                    </button>
                    <form action="{{ url('delete-ijin') }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <input type="hidden" value="" name="delete_id" id="delete_id">
                        <button type="submit" class="btn btn-light-primary ms-1" id="confirm_delete_yes"
                            data-bs-dismiss="modal">
                            <span class="">Ya, Hapus</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- Approve Modal --}}
    <div class="modal fade text-left modal-borderless" id="approveModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Konfirmasi Persetujuan Surat Izin</h5>
                    <button type="button" class="close rounded-pill" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p>
                        Surat izin keluar akan disetujui oleh Anda dan akan langsung di cetak
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-danger" data-bs-dismiss="modal">
                        <span class="">Batalkan</span>
                    </button>
                    <form action="{{ url('approve-ijin') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" value="" name="approve_id" id="approve_id">
                        <button type="submit" value="ditolak" name="decision" class="btn btn-light-warning ms-1"
                            data-bs-dismiss="modal">
                            <span class="">Tidak, Tolak Saja</span>
                        </button>
                        <button type="submit" value="disetujui" name="decision" class="btn btn-light-primary ms-1"
                            data-bs-dismiss="modal">
                            <span class="">Ya, Setujui</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- Aksi Filter Modal --}}
    <div class="modal fade text-left" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel19">Filter Data</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="{{ url('data-ijin') }}" method="GET">
                    <div class="modal-body">
                        <div class="accordion accordion-flush" id="accordionFlushExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingOne">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseOne" aria-expanded="false"
                                        aria-controls="flush-collapseOne">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-2 align-items-center">
                                            <div>Berdasarkan Kelas</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_kelas"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseOne" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <select name="kelas_id" id="kelas_id" class="form-control form-control-lg">
                                                {{-- Ajax Kelas Request DOM --}}
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseTwo" aria-expanded="false"
                                        aria-controls="flush-collapseTwo">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-3 align-items-center">
                                            <div>Berdasarkan Rentang Tanggal</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_tanggal"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseTwo" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingTwo" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <div class="d-flex justify-content-start gap-2 align-items-center">
                                                <input type="text" readonly placeholder="Tanggal Awal"
                                                    autocomplete="off" name="start_date" id="start_date"
                                                    class="form-control form-control-lg">
                                                <span>-</span>
                                                <input type="text" readonly placeholder="Tanggal Akhir"
                                                    name="end_date" autocomplete="off" id="end_date"
                                                    class="form-control form-control-lg">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseThree" aria-expanded="false"
                                        aria-controls="flush-collapseThree">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-2 align-items-center">
                                            <div>Berdasarkan NIS Siswa</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_siswa"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseThree" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <input type="text" maxlength="4" pattern="[0-9]{4}"
                                                title="Hanya 4 Angka Untuk NIS" placeholder="NIS Siswa"
                                                autocomplete="off" name="nis_siswa" id="nis_siswa"
                                                class="form-control form-control-lg">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingFour">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseFour" aria-expanded="false"
                                        aria-controls="flush-collapseFour">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-2 align-items-center">
                                            <div>Berdasarkan Alasan Izin</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_keterangan"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseFour" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingFour" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <input type="text" placeholder="Kata kunci" name="keterangan"
                                                id="keterangan" class="form-control form-control-lg">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingFive">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseFive" aria-expanded="false"
                                        aria-controls="flush-collapseFive">
                                        <div
                                            class="fs-6 fw-bold d-flex w-100 justify-content-start gap-2 align-items-center">
                                            <div>Berdasarkan Status</div>
                                            <i class="bi bi-funnel-fill mb-2 d-none" id="active_filter_status"></i>
                                        </div>
                                    </button>
                                </h2>
                                <div id="flush-collapseFive" class="accordion-collapse collapse"
                                    aria-labelledby="flush-headingFive" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <div class="container">
                                            <select name="status" id="status" class="form-control form-control-lg">
                                                <option value="" selected disabled>Pilih Status</option>
                                                <option value="pending">Pending</option>
                                                <option value="disetujui">Disetujui</option>
                                                <option value="ditolak">Ditolak</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">
                            <span class="">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1" data-bs-dismiss="modal">
                            <span class="">Filter</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>

    {{-- Light Picker CDN --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/litepicker/2.0.12/litepicker.js"
        integrity="sha512-ZbnsrTCJAJWynwgi3ndt7jcjwrJfHNzUh/mZakBRhZG8lYgMVtZLxY2CG4GuONoER9E8iiuupt4fnrNfXy+aGA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/litepicker/2.0.12/plugins/mobilefriendly.min.js"
        integrity="sha512-oGLJsXoz/9rjlOQ+iUaOZo/S0IOlN35P/Iv5JdYAUP3TaW2hg0FvhsW3loRAbET59xFCSAwnsc7i9ULVnZuAtQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        const picker = new Litepicker({
            element: document.getElementById('start_date'),
            elementEnd: document.getElementById('end_date'),
            singleMode: false,
            allowRepick: true,
            plugins: ['mobilefriendly'],
            tooltipText: {
                one: 'Rentang Hari',
                other: 'Rentang Hari'
            },
            tooltipNumber: (totalDays) => {
                return totalDays - 1;
            },
        })
    </script>


    <script>
        function removeParams(param) {
            const params = new URLSearchParams(window.location.search);
            if (param == "date_range") {
                params.delete('start_date');
                params.delete('end_date');
            } else if (param == "kelas") {
                params.delete('kelas_id')
            } else {
                params.delete(param);
            }
            const newURL = `${window.location.origin}${window.location.pathname}?${params.toString()}`;
            window.location.href = newURL;
        }
    </script>

    <script>
        window.onload = () => {
            let params = new URLSearchParams(window.location.search);
            let select = document.getElementById('kelas_id');
            if (params.get('kelas_id') || params.get('start_date') || params.get('end_date') || params.get(
                    'nis_siswa') || params.get('keterangan') || params.get('status')) {
                $("#clear_filter").removeClass('d-none');
            }
        }


        function readyFn() {
            kelasReady();
            tanggalReady();
            nisReady();
            keteranganReady();
            statusReady();
        }

        function kelasReady() {
            // Params
            let params = new URLSearchParams(window.location.search);

            let kelasSelect = document.getElementById('kelas_id');
            if (kelasSelect.querySelector('option') == null) {
                const optDefault = document.createElement('option');
                optDefault.value = "Fara";
                optDefault.innerHTML = "Pilih Kelas";
                $("#kelas_id").append(optDefault);
                $("#kelas_id").find('option[value="Fara"]').prop('disabled', true);
                $.ajax({
                    type: 'get',
                    url: "{{ url('/kelas?type=siswa') }}",
                    success: function(data) {
                        data.forEach((item) => {
                            const opt = document.createElement('option');
                            opt.value = item.id;
                            opt.innerHTML = item.kelas;
                            $("#kelas_id").append(opt);
                        })
                        if (params.get('kelas_id')) {
                            $("#active_filter_kelas").removeClass('d-none');
                            $("#kelas_id").val(params.get('kelas_id'));
                        }
                    }
                })
            }
        }

        function tanggalReady() {
            // Params
            let params = new URLSearchParams(window.location.search);
            if (params.get('start_date') && params.get('end_date')) {
                $("#active_filter_tanggal").removeClass('d-none');
                $("#start_date").val(params.get('start_date'))
                $("#end_date").val(params.get('end_date'))
            }
        }

        function nisReady() {
            let params = new URLSearchParams(window.location.search);
            if (params.get('nis_siswa')) {
                $("#active_filter_siswa").removeClass('d-none');
                $("#nis_siswa").val(params.get('nis_siswa'))
            }
        }

        function keteranganReady() {
            let params = new URLSearchParams(window.location.search);
            if (params.get('keterangan')) {
                $("#active_filter_keterangan").removeClass('d-none');
                $("#keterangan").val(params.get('keterangan'))
            }
        }

        function statusReady() {
            let params = new URLSearchParams(window.location.search);
            if (params.get('status')) {
                $("#active_filter_status").removeClass('d-none');
                $("#status").val(params.get('status'))
            }
        }

        function getParams() {
            let params = new URLSearchParams(window.location.search);
            let sendParams = [];
            params.forEach((val, key) => {
                sendParams[key] = val;
            });
            return sendParams;
        }

        function readyExport() {
            let redirectURL = new URL(`${window.location.origin}/export-ijin`);
            let paramList = getParams();
            for (var key in paramList) {
                if (paramList.hasOwnProperty(key)) {
                    redirectURL.searchParams.set(key, paramList[key]);
                }
            }
            window.open(redirectURL.toString(), '_blank');
        }

        function setIdToDelete(id) {
            $("#delete_id").val(id);
        }

        function readyApprove(id) {
            $("#approve_id").val(id);
        }
    </script>
@endsection
