<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $title }}</title>
    <link rel="stylesheet" href="/assets/compiled/css/app.css">
    <link rel="shortcut icon" href="/assets/compiled/svg/clock-history.svg" type="image/x-icon">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=JetBrains+Mono&display=swap');
        @media print {
          .ticket {page-break-inside:avoid;}
        }
        * {
            /*17 big; 14 medium; 12 small*/
            font-size: 12px;
            font-family: 'JetBrains Mono', sans-serif;
            margin : 0;
        }

        .ticket {
            /* Default 155px */
            width: 58mm;
            /*max-width: 200px;*/
            /*height: 500mm;*/
        }
        .signature-area{
            /* Default 155px */
            width: 30mm;
            /*height: 10px;*/
        }

    </style>
</head>

<body class="bg-white">
    <div class="ticket">
        <div class="fw-bold fs-5 mb-2">Surat Keterangan <br> <span class="fs-5 text-uppercase" style="letter-spacing: 4.5px">Izin Keluar</span> <br> TJKT SMKN 2 Kudus</div>
        <div class="mb-1">
            <div class="">
                <div class="fw-semibold">
                    <span>Nama</span>
                    @if ($ijin->user->nis == '5939' || $ijin->user->nis == '5917')
                    <span>
                    <i class="bi bi-person-fill-check mb-3 fs-4"></i>
                    </span>
                    @endif
                </div>
                <div class="">{{ $ijin->user->nama }}</div>
            </div>
            <div class="">
                <div class="fw-semibold">NIS | Kelas</div>
                <div class="">{{ $ijin->user->nis }} | {{ $ijin->user->kelas->kelas }}</div>
            </div>
            <div class="">
                <div class="fw-semibold">Waktu Izin</div>
                <div class="">{{ date_format(date_create($ijin->waktu_ijin), 'd M Y - H:i') }}</div>
            </div>
            <div class="">
                <div class="fw-semibold">Alasan</div>
                <div class="">{{ $ijin->keterangan }}</div>
            </div>
        </div>
        <div class="mb-2"><span class="fw-bold">Diperbolehkan <br></span> keluar jam ke
            <span class="fw-bold fs-5">{{ $ijin->jam_ke }}</span>
        </div>
        <div class="d-flex justify-content-start align-items-start">
            <div class="">
                <div class="">Guru Mapel,</div>
                <div class="signature-area"></div>
                <div class="">{{ $ijin->guru->nama }}</div>
            </div>
            <div class="">
                <div class="">Guru Piket,</div>
                <div class="signature-area"></div>
                <div class="">{{ $ijin->disetujui_oleh->nama }}</div>
            </div>
        </div>

    </div>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
