<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ijin_transaksis', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained();
            $table->foreignId('kelas_id')->constrained();
            $table->unsignedBigInteger('guru_id');
            $table->foreign('guru_id')->references('id')->on('users')->onDelete('cascade');
            $table->enum('status', ['pending', 'disetujui', 'ditolak']);
            $table->unsignedBigInteger('disetujui_oleh_id')->nullable();
            $table->foreign('disetujui_oleh_id')->references('id')->on('users')->onDelete('cascade');
            $table->string('jam_ke', 2);
            $table->text('keterangan')->nullable();
            $table->dateTime('waktu_ijin');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ijin_transaksis');
    }
};
