<?php

namespace App\Http\Controllers;

use App\Imports\GuruPiketImport;
use App\Models\User;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class GuruPiketController extends Controller
{
    public function index()
    {
        $guru_pikets = User::with('kelas')->where('kelas_id', 41)->get();
        $title = 'Data Guru Piket';
        return view('admin.master.guru_piket.data_guru_piket', compact('guru_pikets', 'title'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nis' => 'required',
            'nisn' => 'required',
            'nama' => 'required',
            'gender' => 'required',
        ]);
        User::create([
            'nis' => $request->nis,
            'nisn' => $request->nisn,
            'nama' => $request->nama,
            'gender' => $request->gender,
            'kelas_id' => 41,
        ]);
        return back()->with('success', 'Guru Piket baru berhasil ditambahkan');
    }

    public function show($id)
    {
        $guru_piket = User
            ::where('id', $id)
            ->first();
        return response()->json($guru_piket, 200);
    }

    public function update(Request $request, $id)
    {
        $guru_piket = User::where('id', $id)->first();
        if ($guru_piket) {
            $guru_piket->update($request->all());
            return back()->with('success', 'Data Guru Piket berhasil diperbarui');
        }
    }

    public function importData(Request $request)
    {
        $request->validate(
            [
                'file_siswa' => 'mimes:xls,xlsx',
            ],
            [
                'file_siswa.mimes' => 'File ditolak, hanya menerima file excel',
            ],
        );
        $data = $request->file('file_siswa');
        $file_name = $data->getClientOriginalName();
        $data->move('Data_Guru', $file_name);
        Excel::import(new GuruPiketImport(), \public_path('/Data_Guru/' . $file_name));

        return back()->with('success', 'Data Guru Piket Berhasil Di Import');
    }

    public function exportData()
    {
        $guru_pikets = User::where('kelas_id', 41)
            ->get();
        $title = 'Cetak Data Guru Piket';
        return view('admin.master.guru_piket.data_guru_piket_export', compact('guru_pikets', 'title'));
    }

    public function cetak()
    {
        $guru_pikets = User::where('kelas_id', 41)
            ->get();
        $title = 'Cetak Semua ID Card';
        return view('admin.master.guru_piket.data_guru_piket_cetak', compact('guru_pikets', 'title'));
    }

    public function destroy($id)
    {
        $guru_piket = User::where('id', $id)->first();
        if ($guru_piket) {
            $guru_piket->delete();
            return back()->with('success', 'Data Guru Piket berhasil dihapus');
        }
    }
}
