<?php

namespace App\Http\Controllers;

use App\Models\IjinTransaksi;
use App\Models\Transaksi;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(){
        $users = User::where('password', NULL)->count();
        $telats = Transaksi::count();
        $telats_pending = Transaksi::where('status', 'pending')->count();
        $ijins = IjinTransaksi::count();
        $ijins_pending = IjinTransaksi::where('status', 'pending')->count();
        $my_approved_count = [
            'terlambat' => Transaksi::where('status', 'disetujui')->where('disetujui_oleh_id', auth()->user()->id)->count(),
            'izin' => IjinTransaksi::where('status', 'disetujui')->where('disetujui_oleh_id', auth()->user()->id)->count(),
        ];
        return view('admin.index', ['title' => 'Dashboard'], compact('users', 'telats', 'ijins', 'telats_pending', 'ijins_pending', 'my_approved_count'));
    }
}
