<?php

namespace App\Console;

use App\Models\IjinTransaksi;
use App\Models\Transaksi;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $this->suratKeteranganHandle();
    }

    private function suratKeteranganHandle(){
        // Handle Ketika Umur Surat Status Pending Lebih Dari 1 Hari Akan Dihapus
        $terlambats = Transaksi::where('status', 'pending')->get();
        $ijins = IjinTransaksi::where('status', 'pending')->get();
        if($terlambats->count() > 0){
            foreach ($terlambats as $item){
                $item->delete();
            }
        }
        if($ijins->count() > 0){
            foreach ($ijins as $item){
                $item->delete();
            }
        }
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
