<!DOCTYPE html>
<html>
<head>
    <title>Jurnal Mengajar - <?php echo e($journal->date->format('d/m/Y')); ?></title>
    <style>
        body { font-family: sans-serif; font-size: 13px; line-height: 1.6; color: #333; }
        .header { border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 20px; text-align: center; }
        .info-grid { display: block; margin-bottom: 25px; }
        .info-item { margin-bottom: 8px; }
        .label { font-weight: bold; width: 150px; display: inline-block; }
        .section-title { font-weight: bold; font-size: 15px; margin-top: 25px; border-bottom: 1px solid #eee; padding-bottom: 5px; }
        .material-box { background: #f9f9f9; padding: 15px; border: 1px solid #eee; border-radius: 5px; margin-top: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background: #f2f2f2; }
        .status-hadir { color: green; font-weight: bold; }
        .status-sakit { color: orange; }
        .status-izin { color: blue; }
        .status-alpa { color: red; font-weight: bold; }
    </style>
</head>
<body>
    <div class="header">
        <h2>BUKTI MENGAJAR (JURNAL DIGITAL)</h2>
        <p><?php echo e($journal->npsn); ?> - <?php echo e(config('app.school_name', 'SMK Negeri Jurnal')); ?></p>
    </div>

    <div class="info-grid">
        <div class="info-item"><span class="label">Nama Guru</span>: <?php echo e($journal->teacher->name); ?></div>
        <div class="info-item"><span class="label">Mata Pelajaran</span>: <?php echo e($journal->subject->name); ?> (<?php echo e($journal->subject->code); ?>)</div>
        <div class="info-item"><span class="label">Kelas</span>: <?php echo e($journal->class->name); ?></div>
        <div class="info-item"><span class="label">Waktu</span>: <?php echo e($journal->date->format('l, d F Y')); ?> (<?php echo e($journal->hour_start); ?> - <?php echo e($journal->hour_end); ?>)</div>
    </div>

    <div class="section-title">Materi Pembelajaran</div>
    <div class="material-box">
        <?php echo e($journal->material); ?>

    </div>

    <?php if($journal->notes): ?>
    <div class="section-title">Catatan Tambahan</div>
    <div style="margin-top: 10px;"><?php echo e($journal->notes); ?></div>
    <?php endif; ?>

    <div class="section-title">Daftar Ketidakhadiran Siswa</div>
    <table>
        <thead>
            <tr>
                <th width="30">No</th>
                <th>Nama Siswa</th>
                <th>NIS</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $no = 1; ?>
            <?php $__currentLoopData = $journal->class->students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $status = $journal->absent_list[$student->id] ?? 'Hadir'; ?>
                <?php if($status !== 'Hadir'): ?>
                <tr>
                    <td><?php echo e($no++); ?></td>
                    <td><?php echo e($student->name); ?></td>
                    <td><?php echo e($student->nis); ?></td>
                    <td><span class="status-<?php echo e(strtolower($status)); ?>"><?php echo e($status); ?></span></td>
                </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if($no === 1): ?>
                <tr>
                    <td colspan="4" style="text-align: center; font-style: italic;">Seluruh siswa hadir (NIHIL)</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div style="margin-top: 50px; width: 100%;">
        <div style="float: right; text-align: center; width: 200px;">
            <p>Dicetak secara sistem,</p>
            <br><br><br>
            <p><strong><?php echo e($journal->teacher->name); ?></strong></p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\JurnalV2\jurnalbackend\resources\views/pdf/journal.blade.php ENDPATH**/ ?>