<!DOCTYPE html>
<html>
<head>
    <title>Jurnal Mengajar</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .footer { position: fixed; bottom: 0; width: 100%; text-align: right; font-size: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>REKAPITULASI JURNAL MENGAJAR</h2>
        <p>Periode: <?php echo e($startDate); ?> s/d <?php echo e($endDate); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Tanggal</th>
                <th>Kelas</th>
                <th>Mapel</th>
                <th>Guru</th>
                <th>Materi</th>
                <th>H/S/I/A</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $journals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($j->date->format('d/m/Y')); ?></td>
                    <td><?php echo e($j->class->name ?? 'N/A'); ?></td>
                    <td><?php echo e($j->subject->name ?? 'N/A'); ?></td>
                    <td><?php echo e($j->teacher->name ?? 'N/A'); ?></td>
                    <td><?php echo e($j->material); ?></td>
                    <td>
                        <?php echo e(count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Hadir'))); ?>/
                        <?php echo e(count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Sakit'))); ?>/
                        <?php echo e(count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Izin'))); ?>/
                        <?php echo e(count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Alfa'))); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        Dicetak pada: <?php echo e(now()->format('d/m/Y H:i')); ?>

    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\JurnalV2\jurnalbackend\resources\views/pdf/journals.blade.php ENDPATH**/ ?>