<!DOCTYPE html>
<html>
<head>
    <title>Rekap Absensi</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; margin-bottom: 10px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .class-title { margin-top: 30px; font-weight: bold; font-size: 14px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>LAPORAN REKAPITULASI ABSENSI SISWA</h2>
        <p>Periode: <?php echo e($startDate); ?> s/d <?php echo e($endDate); ?></p>
    </div>

    <?php
        $grouped = collect($report)->groupBy(fn($r) => $r['class_name'] ?? 'N/A');
    ?>

    <?php $__currentLoopData = $grouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $className => $students): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="class-title">Kelas: <?php echo e($className); ?></div>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama Siswa</th>
                    <th>NIS</th>
                    <th>H</th>
                    <th>S</th>
                    <th>I</th>
                    <th>A</th>
                    <th>Persentase Hadir</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i+1); ?></td>
                        <td><?php echo e($s['name']); ?></td>
                        <td><?php echo e($s['nis']); ?></td>
                        <td><?php echo e($s['hadir']); ?></td>
                        <td><?php echo e($s['sakit']); ?></td>
                        <td><?php echo e($s['izin']); ?></td>
                        <td><?php echo e($s['alpa']); ?></td>
                        <td><?php echo e($s['percentage']); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html><?php /**PATH C:\laragon\www\JurnalV2\jurnalbackend\resources\views/pdf/attendance.blade.php ENDPATH**/ ?>