<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\JurnalController;
use App\Http\Controllers\ReportingController;
use App\Http\Controllers\TeacherController;
use App\Http\Controllers\ImportExportController;
use App\Http\Controllers\SupervisionController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\ClassController;
use App\Http\Controllers\Admin\SubjectController;
use App\Http\Controllers\Admin\StudentController;
use App\Http\Controllers\Admin\DashboardController;

    // Public Routes //
Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register']);

    // Protected Routes //
Route::middleware('auth:sanctum')->group(function () {

    // Auth Routes //
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/profile', [AuthController::class, 'profile']);
    Route::put('/profile', [AuthController::class, 'updateProfile']);
    Route::post('/profile/avatar', [AuthController::class, 'updateAvatar']);

    // Jurnal Routes //
    Route::get('/journals', [JurnalController::class, 'index']);
    Route::get('/journals/{journal}', [JurnalController::class, 'show']);
    Route::delete('/journals/{journal}', [JurnalController::class, 'destroy']);

    Route::middleware('role:guru')->group(function () {
        Route::post('/journals', [JurnalController::class, 'store']);
        Route::put('/journals/{journal}', [JurnalController::class, 'update']);
        
        Route::prefix('teacher')->group(function () {
            Route::get('/classes', [TeacherController::class, 'myClasses']);
            Route::get('/subjects', [TeacherController::class, 'mySubjects']);
            Route::post('/subjects', [TeacherController::class, 'storeSubject']);
            Route::put('/subjects/{subject}', [TeacherController::class, 'updateSubject']);
            Route::delete('/subjects/{subject}', [TeacherController::class, 'destroySubject']);
            Route::get('/students', [TeacherController::class, 'myStudents']);
            Route::get('/dashboard', [TeacherController::class, 'dashboardStats']);
        });
    });

    Route::get('/journals/{id}/pdf', [JurnalController::class, 'exportPdf']);

    // Reporting Routes //
    Route::prefix('reports')->group(function () {
        Route::get('/attendance', [ReportingController::class, 'attendanceReport']);
        Route::get('/teaching-hours', [ReportingController::class, 'teachingHoursReport']);
        Route::get('/supervision', [ReportingController::class, 'supervisionReport']);
    });

    // Supervision Routes //
    Route::get('/supervision/today', [SupervisionController::class, 'getTodayJournals']);

    // Import Export Routes //
    Route::post('/import/students', [ImportExportController::class, 'importStudents']);
    
    Route::get('/export/journals/excel', [ImportExportController::class, 'exportJournalsExcel']);
    Route::get('/export/journals/pdf', [ImportExportController::class, 'exportJournalsPdf']);
    
    Route::get('/export/attendance/excel', [ImportExportController::class, 'exportAttendanceExcel']);
    Route::get('/export/attendance/pdf', [ImportExportController::class, 'exportAttendancePdf']);
    
    Route::get('/export/teaching-hours/excel', [ImportExportController::class, 'exportTeachingHoursExcel']);
    Route::get('/export/teaching-hours/pdf', [ImportExportController::class, 'exportTeachingHoursPdf']);

  // Admin Routes // 
    Route::middleware('admin')->prefix('admin')->group(function () {
        Route::get('/dashboard', [DashboardController::class, 'dashboardStats']);
        Route::get('/users', [UserController::class, 'index']);
        Route::post('/users', [UserController::class, 'store']);
        Route::get('/users/{user}', [UserController::class, 'show']);
        Route::put('/users/{user}', [UserController::class, 'update']);
        Route::delete('/users/{user}', [UserController::class, 'destroy']);

        Route::get('/classes', [ClassController::class, 'index']);
        Route::post('/classes', [ClassController::class, 'store']);
        Route::put('/classes/{class}', [ClassController::class, 'update']);
        Route::delete('/classes/{class}', [ClassController::class, 'destroy']);

        Route::get('/subjects', [SubjectController::class, 'index']);
        Route::post('/subjects', [SubjectController::class, 'store']);
        Route::put('/subjects/{subject}', [SubjectController::class, 'update']);
        Route::delete('/subjects/{subject}', [SubjectController::class, 'destroy']);

        Route::get('/students', [StudentController::class, 'index']);
        Route::post('/students', [StudentController::class, 'store']);
        Route::put('/students/{student}', [StudentController::class, 'update']);
        Route::delete('/students/{student}', [StudentController::class, 'destroy']);
    });
});
