<!DOCTYPE html>
<html>
<head>
    <title>Jurnal Mengajar</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; margin-bottom: 10px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .footer { position: fixed; bottom: 0; width: 100%; text-align: right; font-size: 10px; }
        .class-title { margin-top: 30px; font-weight: bold; font-size: 14px; }
        .summary { font-size: 11px; margin-top: 5px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>REKAPITULASI JURNAL MENGAJAR</h2>
        <p>Periode: {{ $startDate }} s/d {{ $endDate }}</p>
    </div>

    @php
        // Group journals by class name
        $grouped = $journals->groupBy(fn($j) => $j->class->name ?? 'N/A');
    @endphp

    @foreach($grouped as $className => $items)
        <div class="class-title">Kelas: {{ $className }}</div>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Tanggal</th>
                    <th>Mapel</th>
                    <th>Guru</th>
                    <th>Materi</th>
                    <th>H/S/I/A</th>
                </tr>
            </thead>
            <tbody>
                @foreach($items as $index => $j)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $j->date->format('d/m/Y') }}</td>
                        <td>{{ $j->subject->name ?? 'N/A' }}</td>
                        <td>{{ $j->teacher->name ?? 'N/A' }}</td>
                        <td>{{ $j->material }}</td>
                        <td>
                            {{ count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Hadir')) }}/
                            {{ count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Sakit')) }}/
                            {{ count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Izin')) }}/
                            {{ count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Alfa')) }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        @php
            $totalHadir = $items->sum(fn($j) => count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Hadir')));
            $totalSakit = $items->sum(fn($j) => count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Sakit')));
            $totalIzin  = $items->sum(fn($j) => count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Izin')));
            $totalAlfa  = $items->sum(fn($j) => count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Alfa')));
        @endphp

        <p class="summary">
            Total Kehadiran Kelas {{ $className }} → H: {{ $totalHadir }} / S: {{ $totalSakit }} / I: {{ $totalIzin }} / A: {{ $totalAlfa }}
        </p>
    @endforeach

    <div class="footer">
        Dicetak pada: {{ now()->format('d/m/Y H:i') }}
    </div>
</body>
</html>