<!DOCTYPE html>
<html>
<head>
    <title>Jurnal Mengajar - {{ $journal->date->format('d/m/Y') }}</title>
    <style>
        body { font-family: sans-serif; font-size: 13px; line-height: 1.6; color: #333; }
        .header { border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 20px; text-align: center; }
        .info-grid { display: block; margin-bottom: 25px; }
        .info-item { margin-bottom: 8px; }
        .label { font-weight: bold; width: 150px; display: inline-block; }
        .section-title { font-weight: bold; font-size: 15px; margin-top: 25px; border-bottom: 1px solid #eee; padding-bottom: 5px; }
        .material-box { background: #f9f9f9; padding: 15px; border: 1px solid #eee; border-radius: 5px; margin-top: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background: #f2f2f2; }
        .status-hadir { color: green; font-weight: bold; }
        .status-sakit { color: orange; }
        .status-izin { color: blue; }
        .status-alpa { color: red; font-weight: bold; }
    </style>
</head>
<body>
    <div class="header">
        <h2>BUKTI MENGAJAR (JURNAL DIGITAL)</h2>
        <p>{{ $journal->npsn }} - {{ config('app.school_name', 'SMK Negeri Jurnal') }}</p>
    </div>

    <div class="info-grid">
        <div class="info-item"><span class="label">Nama Guru</span>: {{ $journal->teacher->name }}</div>
        <div class="info-item"><span class="label">Mata Pelajaran</span>: {{ $journal->subject->name }} ({{ $journal->subject->code }})</div>
        <div class="info-item"><span class="label">Kelas</span>: {{ $journal->class->name }}</div>
        <div class="info-item"><span class="label">Waktu</span>: {{ $journal->date->format('l, d F Y') }} ({{ $journal->hour_start }} - {{ $journal->hour_end }})</div>
    </div>

    <div class="section-title">Materi Pembelajaran</div>
    <div class="material-box">
        {{ $journal->material }}
    </div>

    @if($journal->notes)
    <div class="section-title">Catatan Tambahan</div>
    <div style="margin-top: 10px;">{{ $journal->notes }}</div>
    @endif

    <div class="section-title">Daftar Ketidakhadiran Siswa</div>
    <table>
        <thead>
            <tr>
                <th width="30">No</th>
                <th>Nama Siswa</th>
                <th>NIS</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @php $no = 1; @endphp
            @foreach($journal->class->students as $student)
                @php $status = $journal->absent_list[$student->id] ?? 'Hadir'; @endphp
                @if($status !== 'Hadir')
                <tr>
                    <td>{{ $no++ }}</td>
                    <td>{{ $student->name }}</td>
                    <td>{{ $student->nis }}</td>
                    <td><span class="status-{{ strtolower($status) }}">{{ $status }}</span></td>
                </tr>
                @endif
            @endforeach
            @if($no === 1)
                <tr>
                    <td colspan="4" style="text-align: center; font-style: italic;">Seluruh siswa hadir (NIHIL)</td>
                </tr>
            @endif
        </tbody>
    </table>

    <div style="margin-top: 50px; width: 100%;">
        <div style="float: right; text-align: center; width: 200px;">
            <p>Dicetak secara sistem,</p>
            <br><br><br>
            <p><strong>{{ $journal->teacher->name }}</strong></p>
        </div>
    </div>
</body>
</html>
