<!DOCTYPE html>
<html>
<head>
    <title>Rekap Absensi</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; margin-bottom: 10px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .class-title { margin-top: 30px; font-weight: bold; font-size: 14px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>LAPORAN REKAPITULASI ABSENSI SISWA</h2>
        <p>Periode: {{ $startDate }} s/d {{ $endDate }}</p>
    </div>

    @php
        $grouped = collect($report)->groupBy(fn($r) => $r['class_name'] ?? 'N/A');
    @endphp

    @foreach($grouped as $className => $students)
        <div class="class-title">Kelas: {{ $className }}</div>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama Siswa</th>
                    <th>NIS</th>
                    <th>H</th>
                    <th>S</th>
                    <th>I</th>
                    <th>A</th>
                    <th>Persentase Hadir</th>
                </tr>
            </thead>
            <tbody>
                @foreach($students as $i => $s)
                    <tr>
                        <td>{{ $i+1 }}</td>
                        <td>{{ $s['name'] }}</td>
                        <td>{{ $s['nis'] }}</td>
                        <td>{{ $s['hadir'] }}</td>
                        <td>{{ $s['sakit'] }}</td>
                        <td>{{ $s['izin'] }}</td>
                        <td>{{ $s['alpa'] }}</td>
                        <td>{{ $s['percentage'] }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endforeach
</body>
</html>