<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ClassModel;

class ClassSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $npsn = '20317529';

        $majorsByGrade = [
            'X'   => ['TJKT', 'TKRO', 'TAV'],
            'XI'  => ['TKJ', 'TKR', 'TE'],
            'XII' => ['TKJ', 'TKR', 'TE'],
        ];

        foreach ($majorsByGrade as $grade => $majors) {
            foreach ($majors as $major) {
                for ($i = 1; $i <= 4; $i++) {
                    ClassModel::create([
                        'name'  => $grade . ' ' . $major . ' ' . $i,
                        'major' => $major,
                        'npsn'  => $npsn,
                    ]);
                }
            }
        }
    }
}