<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subjects', function (Blueprint $row) {
            if (!Schema::hasColumn('subjects', 'class_id')) {
                $row->foreignId('class_id')->nullable()->constrained('classes')->onDelete('cascade');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subjects', function (Blueprint $row) {
            $row->dropForeign(['class_id']);
            $row->dropColumn('class_id');
        });
    }
};
