<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasColumn('classes', 'npsn')) {
            Schema::table('classes', function (Blueprint $table) {
                $table->string('npsn')->nullable()->after('major');
            });
        }
        if (!Schema::hasColumn('subjects', 'npsn')) {
            Schema::table('subjects', function (Blueprint $table) {
                $table->string('npsn')->nullable()->after('class_id');
            });
        }
        if (!Schema::hasColumn('students', 'npsn')) {
            Schema::table('students', function (Blueprint $table) {
                $table->string('npsn')->nullable()->after('class_id');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('classes', 'npsn')) {
            Schema::table('classes', function (Blueprint $table) {
                $table->dropColumn('npsn');
            });
        }
        if (Schema::hasColumn('subjects', 'npsn')) {
            Schema::table('subjects', function (Blueprint $table) {
                $table->dropColumn('npsn');
            });
        }
        if (Schema::hasColumn('students', 'npsn')) {
            Schema::table('students', function (Blueprint $table) {
                $table->dropColumn('npsn');
            });
        }
    }
};
