<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('teaching_journals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('teacher_id')->constrained('users');
            $table->foreignId('class_id')->constrained('classes');
            $table->foreignId('subject_id')->constrained('subjects');
            $table->date('date');
            $table->time('hour_start');
            $table->time('hour_end');
            $table->text('material'); // Materi yang diajarkan
            $table->json('absent_list')->nullable(); // Format: {siswa_id: 'Hadir/Sakit/Izin/Alfa'}
            $table->text('notes')->nullable();
            $table->string('npsn')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('teaching_journals');
    }
};