<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = ['name', 'email', 'password', 'role', 'npsn', 'profile_photo'];
    protected $hidden = ['password', 'remember_token'];

    public function journals()
    {
        return $this->hasMany(TeachingJurnal::class, 'teacher_id');
    }

    public function scopeByNpsn($query)
    {
        return $query->where('npsn', auth()->user()->npsn);
    }

    protected $appends = ['avatar_url'];

    public function getAvatarUrlAttribute()
    {
        return $this->profile_photo ? asset('storage/' . $this->profile_photo) : null;
    }
}