<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClassModel extends Model
{
    protected $table = 'classes';

    protected $fillable = ['name', 'major', 'npsn'];

    public function students()
    {
        return $this->hasMany(Student::class, 'class_id');
    }

    public function jurnals()
    {
        return $this->hasMany(TeachingJurnal::class, 'class_id');
    }

    public function subjects()
{
    return $this->hasMany(Subject::class, 'class_id');
}
}