<?php

namespace App\Imports;

use App\Models\Student;
use App\Models\ClassModel;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class StudentsImport implements ToCollection, WithHeadingRow
{
    public function collection(Collection $rows)
    {
        $npsn = auth()->user()->npsn;
        $imported = 0;
        $skipped = 0;

        foreach ($rows as $row) {
            // Get name from either 'name' or 'nama' column
            $name = $row['name'] ?? $row['nama'] ?? null;
            if (!$name) {
                $skipped++;
                continue;
            }

            // Get NIS
            $nis = $row['nis'] ?? null;
            if (!$nis) {
                $skipped++;
                continue;
            }

            // Get gender with default
            $gender = $row['gender'] ?? $row['jenis_kelamin'] ?? 'L';
            $gender = strtoupper(trim($gender));
            if (!in_array($gender, ['L', 'P'])) {
                $gender = 'L';
            }

            // Try to find class by name or ID
            $classId = $row['class_id'] ?? $row['kelas'] ?? null;
            if (!$classId) {
                $skipped++;
                continue;
            }

            if (!is_numeric($classId)) {
                $class = ClassModel::where('name', $classId)
                    ->where('npsn', $npsn)
                    ->first();
                $classId = $class ? $class->id : null;
            }

            if (!$classId) {
                $skipped++;
                continue;
            }

            // Create or update student
            try {
                Student::updateOrCreate(
                    [
                        'nis' => $nis,
                        'npsn' => $npsn
                    ],
                    [
                        'name' => $name,
                        'gender' => $gender,
                        'class_id' => $classId,
                    ]
                );
                $imported++;
            } catch (\Exception $e) {
                $skipped++;
                \Log::error('Failed to import student: ' . $e->getMessage(), [
                    'row' => $row->toArray()
                ]);
            }
        }

        \Log::info("Import completed: {$imported} imported, {$skipped} skipped");
    }
}