<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\TeachingJurnal;

class SupervisionController extends Controller
{
    public function getTodayJournals()
    {
        $npsn = auth()->user()->npsn;
        $journals = TeachingJurnal::with(['teacher', 'class', 'subject'])
            ->where('npsn', $npsn)
            ->whereHas('teacher', function($q) {
                $q->where('role', 'guru');
            })
            ->whereDate('date', now())
            ->orderBy('created_at', 'desc')
            ->get();

        if ($journals->isEmpty()) {
             $journals = TeachingJurnal::with(['teacher', 'class', 'subject'])
                ->whereHas('teacher', function($q) {
                    $q->where('role', 'guru');
                })
                ->whereDate('date', now())
                ->orderBy('created_at', 'desc')
                ->get();
        }

        return response()->json(['data' => $journals]);
    }
}
