<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Subject;
use Illuminate\Http\Request;

class SubjectController extends Controller
{
    /**
     * Ambil semua mata pelajaran beserta relasi kelas.
     */
    public function index()
    {
        $npsn = auth()->user()->npsn;
        $subjects = Subject::with('class')
            ->where(function($q) use ($npsn) {
                $q->where('npsn', $npsn)
                  ->orWhereHas('class', function($q2) use ($npsn) {
                      $q2->where('npsn', $npsn);
                  });
            })->get();
        if ($subjects->isEmpty()) {
            $subjects = Subject::with('class')->get(); // Fallback
        }
        return response()->json(['data' => $subjects]);
    }

    /**
     * Simpan mata pelajaran baru.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'     => 'required|string',
            'code'     => 'nullable|string',
            'class_id' => 'required|exists:classes,id',
        ]);

        $subject = Subject::create($request->all() + ['npsn' => auth()->user()->npsn]);
        return response()->json($subject, 201);
    }

    /**
     * Update data mata pelajaran.
     */
    public function update(Request $request, Subject $subject)
    {
        $request->validate([
            'name'        => 'required|string',
            'code'        => 'nullable|string',
            'description' => 'nullable|string',
            'class_id'    => 'required|exists:classes,id',
        ]);

        $subject->update($request->all());
        return response()->json(['data' => $subject]);
    }

    /**
     * Hapus mata pelajaran.
     */
    public function destroy(Subject $subject)
    {
        $subject->delete();
        return response()->json(['message' => 'Mata pelajaran dihapus']);
    }
}