<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\Student;
use Illuminate\Http\Request;

class StudentController extends Controller
{
    public function index()
    {
        $npsn = auth()->user()->npsn;
        $students = Student::where('npsn', $npsn)
            ->with('class')
            ->get();
        return response()->json(['data' => $students]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'nis' => 'required|string',
            'gender' => 'required|in:L,P',
            'class_id' => 'required|exists:classes,id'
        ]);

        $student = Student::create($request->all() + ['npsn' => auth()->user()->npsn]);
        return response()->json(['data' => $student], 201);
    }

    public function show(Student $student)
    {
        return response()->json($student);
    }

    public function update(Request $request, Student $student)
    {
        $request->validate([
            'name' => 'sometimes|string',
            'nis' => 'sometimes|string|unique:students,nis,' . $student->id,
            'gender' => 'sometimes|in:L,P',
            'class_id' => 'sometimes|exists:classes,id'
        ]);

        $student->update($request->all());
        return response()->json(['data' => $student]);
    }

    public function destroy(Student $student)
    {
        $student->delete();
        return response()->json(['message' => 'Siswa dihapus']);
    }
}