<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TeachingJurnal;
use App\Models\Student;
use Carbon\Carbon;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function dashboardStats()
    {
        $user = auth()->user();
        $npsn = $user->npsn;
        $today = Carbon::today();

        // Total Journals filtered by NPSN
        $totalJournals = TeachingJurnal::where('npsn', $npsn)->count();
        
        // Today's Journals filtered by NPSN
        $todayJournals = TeachingJurnal::where('npsn', $npsn)
            ->whereDate('date', $today)
            ->count();
        
        // Total Students filtered by NPSN
        $activeStudents = Student::where('npsn', $npsn)->count();

        // Calculate avg attendance from all journals in this school
        $journals = TeachingJurnal::where('npsn', $npsn)->get();
        $totalStudentsSeen = 0;
        $totalHadir = 0;

        foreach ($journals as $journal) {
            if ($journal->absent_list) {
                $list = $journal->absent_list;
                $totalStudentsSeen += count($list);
                foreach ($list as $status) {
                    if ($status === 'Hadir') {
                        $totalHadir++;
                    }
                }
            }
        }

        $avgAttendance = $totalStudentsSeen > 0 ? round(($totalHadir / $totalStudentsSeen) * 100) : 0;

        // Fetch recent journals for the chart (last 30 days or similar, but here we just need them for the frontend component to filter)
        // Alternatively, the dashboard expects full journals list to compute last 7 days chart data
        $recentJournals = TeachingJurnal::with(['teacher', 'class', 'subject'])
            ->where('npsn', $npsn)
            ->orderBy('date', 'desc')
            ->limit(100) // Reasonable limit for dashboard
            ->get();

        return response()->json(['data' => [
            'totalJournals' => $totalJournals,
            'todayJournals' => $todayJournals,
            'activeStudents' => $activeStudents,
            'avgAttendance' => $avgAttendance,
            'journals' => $recentJournals
        ]]);
    }
}
