<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ClassModel;
use Illuminate\Http\Request;

class ClassController extends Controller
{
    public function index()
    {
        $npsn = auth()->user()->npsn;
        $classes = ClassModel::where('npsn', $npsn)->withCount('students')->get();
        return response()->json(['data' => $classes]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'major' => 'nullable|string'
        ]);

        $class = ClassModel::create($request->all() + ['npsn' => auth()->user()->npsn]);
        return response()->json(['data' => $class], 201);
    }

    public function update(Request $request, ClassModel $class)
    {
        $request->validate([
            'name' => 'sometimes|string',
            'major' => 'sometimes|string'
        ]);

        $class->update($request->all());
        return response()->json(['data' => $class]);
    }

    public function destroy(ClassModel $class)
    {
        $class->delete();
        return response()->json(['message' => 'Kelas dihapus']);
    }
}