<?php

namespace App\Exports;

use App\Models\TeachingJurnal;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class TeachingHoursExport implements FromCollection, WithHeadings
{
    protected $npsn;
    protected $startDate;
    protected $endDate;

    public function __construct($npsn, $startDate = null, $endDate = null)
    {
        $this->npsn = $npsn;
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function collection()
    {
        $dateFrom = $this->startDate ?? now()->startOfMonth()->format('Y-m-d');
        $dateTo = $this->endDate ?? now()->endOfMonth()->format('Y-m-d');

        $journals = TeachingJurnal::where('npsn', $this->npsn)
            ->whereBetween('date', [$dateFrom, $dateTo])
            ->with(['teacher', 'subject'])
            ->get();

        return $journals->groupBy('teacher_id')->map(function ($items) {
            $teacher = $items->first()->teacher;
            $subjects = $items->pluck('subject.name')->unique()->implode(', ');
            
            return [
                'teacher_name' => $teacher->name ?? 'Unknown',
                'total_journals' => $items->count(),
                'subjects' => $subjects
            ];
        })->values();
    }

    public function headings(): array
    {
        return [
            'Nama Guru',
            'Total Jam/Jurnal',
            'Mata Pelajaran',
        ];
    }
}
