<?php

namespace App\Exports;
use App\Models\TeachingJournal;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class JournalsExport implements FromCollection, WithHeadings
{
    protected $npsn;
    protected $startDate;
    protected $endDate;

    public function __construct($npsn, $startDate = null, $endDate = null)
    {
        $this->npsn = $npsn;
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function collection()
    {
        $query = \App\Models\TeachingJurnal::where('npsn', $this->npsn)
            ->with(['teacher', 'class', 'subject']);

        if ($this->startDate && $this->endDate) {
            $query->whereBetween('date', [$this->startDate, $this->endDate]);
        }

        return $query->get()
            ->map(function ($j) {
                return [
                    'tanggal' => $j->date->format('Y-m-d'),
                    'jam_mulai' => $j->hour_start,
                    'jam_selesai' => $j->hour_end,
                    'kelas' => $j->class->name ?? 'N/A',
                    'mata_pelajaran' => $j->subject->name ?? 'N/A',
                    'materi' => $j->material,
                    'guru' => $j->teacher->name ?? 'N/A',
                    'hadir' => count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Hadir')),
                    'sakit' => count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Sakit')),
                    'izin' => count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Izin')),
                    'alpa' => count(array_filter($j->absent_list ?? [], fn($v) => $v === 'Alfa')),
                    'catatan' => $j->notes,
                ];
            });
    }

    public function headings(): array
    {
        return [
            'Tanggal',
            'Jam Mulai',
            'Jam Selesai',
            'Kelas',
            'Mata Pelajaran',
            'Materi',
            'Guru',
            'Hadir',
            'Sakit',
            'Izin',
            'Alfa',
            'Catatan',
        ];
    }
}