<?php

namespace App\Exports;

use App\Models\TeachingJurnal;
use App\Models\Student;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class AttendanceExport implements FromCollection, WithHeadings
{
    protected $npsn;
    protected $startDate;
    protected $endDate;
    protected $classId;

    public function __construct($npsn, $startDate = null, $endDate = null, $classId = null)
    {
        $this->npsn = $npsn;
        $this->startDate = $startDate;
        $this->endDate = $endDate;
        $this->classId = $classId;
    }

    public function collection()
    {
        $dateFrom = $this->startDate ?? now()->startOfMonth()->format('Y-m-d');
        $dateTo = $this->endDate ?? now()->endOfMonth()->format('Y-m-d');

        $query = TeachingJurnal::where('npsn', $this->npsn)
            ->whereBetween('date', [$dateFrom, $dateTo]);
        
        if ($this->classId) {
            $query->where('class_id', $this->classId);
        }

        $journals = $query->get();

        $studentQuery = Student::where('npsn', $this->npsn);
        if ($this->classId) {
            $studentQuery->where('class_id', $this->classId);
        }
        $students = $studentQuery->get();

        return $students->map(function ($student) use ($journals) {
            $hadir = 0;
            $sakit = 0;
            $izin = 0;
            $alpa = 0;
            $totalDays = 0;

            foreach ($journals as $journal) {
                if ($journal->absent_list && isset($journal->absent_list[$student->id])) {
                    $status = $journal->absent_list[$student->id];
                    if ($status === 'Hadir') $hadir++;
                    elseif ($status === 'Sakit') $sakit++;
                    elseif ($status === 'Izin') $izin++;
                    elseif ($status === 'Alfa') $alpa++;
                    $totalDays++;
                }
            }

            return [
                'name' => $student->name,
                'nis' => $student->nis,
                'hadir' => $hadir,
                'sakit' => $sakit,
                'izin' => $izin,
                'alpa' => $alpa,
                'percentage' => ($totalDays > 0 ? round(($hadir / $totalDays) * 100) : 0) . '%',
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Nama Siswa',
            'NIS',
            'Hadir',
            'Sakit',
            'Izin',
            'Alfa',
            'Persentase',
        ];
    }
}
