<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($title); ?> - <?php echo e(date('d F Y')); ?></title>
    <link rel="stylesheet" href="/assets/compiled/css/app.css">

</head>

<body class="bg-white">
    <div class="mt-4">
        <h3 class="">Laporan Data Barang Yang Di Pinjam Gudang Ajaib TJKT</h3>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Tanggal Dicetak :</div>
            <span><?php echo e(date('d F Y - H : i')); ?></span>
        </div>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Jumlah Barang Yang Belum Dikembalikan :</div>
            <span><?php echo e($barang_pinjams->count()); ?> Barang</span>
        </div>

        <table class="table table-striped">
            <thead class="bg-primary">
                <th class="text-white">No</th>
                <th class="text-white">Kode Barang</th>
                <th class="text-white">Nama Barang</th>
                <th class="text-white">Peminjam</th>
                <th class="text-white">Keterangan</th>
                <th class="text-white">Waktu Peminjaman</th>
            </thead>
            <tbody>
                <?php $__currentLoopData = $barang_pinjams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i + 1); ?></td>
                        <td><?php echo e($item->barang->kode_barang); ?></td>
                        <td><?php echo e($item->barang->nama_barang); ?></td>
                        <td>
                            <div class="fs-5 fw-bold"><?php echo e($item->user->nama); ?></div>
                            <div> <?php echo e($item->user->nis); ?> | <?php echo e($item->user->kelas->kelas); ?></div>
                        </td>
                        <td>
                            <?php if($item->keterangan): ?>
                            <?php echo e($item->keterangan); ?>

                            <?php else: ?>
                            -
                            <?php endif; ?>
                        </td>
                        <td><?php echo e(date_format(date_create($item->waktu_pinjam), "d M Y | H:i")); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
<?php /**PATH E:\laragon\www\pinjam_barang\resources\views/admin/transaksi/barang_terpinjam_export.blade.php ENDPATH**/ ?>