<?php $__env->startSection('content_admin'); ?>
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">

    <div class="row">
        <div class="col-12">
            <?php echo $__env->make('alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Barang Gudang Yang Telah Dikembalikan</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Kode Barang</th>
                                    <th>Nama Barang</th>
                                    <th>Peminjam</th>
                                    <th>Keterangan</th>
                                    <th>Waktu Pinjam</th>
                                    <th>Waktu Kembali</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $barang_kembalis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i =>  $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="barcode-text"><?php echo e($i + 1); ?></td>
                                        <td><?php echo e($item->barang->kode_barang); ?></td>
                                        <td><?php echo e($item->barang->nama_barang); ?></td>
                                        <td><?php echo e($item->user->nama); ?> <br> <?php echo e($item->user->kelas->kelas); ?></td>
                                        <td>
                                            <?php if($item->keterangan): ?>
                                            <?php echo e($item->keterangan); ?>

                                            <?php else: ?>
                                            -
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(date_format(date_create($item->waktu_pinjam), "d M Y | H:i")); ?></td>
                                        <td><?php echo e(date_format(date_create($item->waktu_kembali), "d M Y | H:i")); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    

    

    

    



    

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>

    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.admin_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\pinjam_barang\resources\views/admin/transaksi/barang_kembali.blade.php ENDPATH**/ ?>