<?php $__env->startSection('content_admin'); ?>
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="/assets/extensions/filepond/filepond.css">

    <div class="row">
        <div class="col-12">
            <?php echo $__env->make('alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div class="">
                        <h4>List Bahan Gudang Ajaib TJKT</h4>
                        <div class="">Bahan yang digunakan untuk sekali pakai</div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center gap-3">
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#newBahanModal">
                            <i class="bi bi-plus-square-fill mb-2 me-1"></i>
                            <small>Bahan Baru</small>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Bahan</th>
                                    <th>Total Stok Bahan</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $bahans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                        <td><?php echo e($i + 1); ?></td>
                                        <td><?php echo e($item->nama_bahan); ?></td>
                                        <td><?php echo e($item->total_stok); ?></td>
                                        <td>
                                            <div class="d-flex justify-content-start gap-2 align-items-center">
                                                <button class="btn btn-light-primary" data-bs-toggle="modal"
                                                    data-bs-target="#addBahanModal" onclick="setId(<?php echo e($item->id); ?>)">
                                                    <i class="bi bi-patch-plus-fill mb-2"></i>
                                                </button>
                                                <button class="btn btn-light-warning" data-bs-toggle="modal"
                                                    data-bs-target="#minusBahanModal" onclick="setId(<?php echo e($item->id); ?>)">
                                                    <i class="bi bi-patch-minus-fill mb-2"></i>
                                                </button>
                                                <button class="btn btn-light-danger" type="button" data-bs-toggle="modal"
                                                    data-bs-target="#hapusBahanModal" onclick="setId(<?php echo e($item->id); ?>)">
                                                    <i class="bi bi-trash-fill mb-2"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    
    <div class="modal fade text-left modal-borderless" id="hapusBahanModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Konfirmasi</h5>
                    <button type="button" class="close rounded-pill" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p>
                        Menghapus Bahan Menyebabkan Hilangnya Data Aktivitas Bahan. Apakah Yakin ?
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-danger" data-bs-dismiss="modal">
                        <i class="bx bx-x d-block d-sm-none"></i>
                        <span class="d-none d-sm-block">Tidak</span>
                    </button>
                    <form action="<?php echo e(url('/admin/bahan-gudang')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <input type="hidden" name="bahan_id_delete" id="bahan_id_delete" value="">
                        <button type="submit" class="btn btn-light-primary ms-1" id="confirm_delete_yes"
                            data-bs-dismiss="modal">
                            <i class="bx bx-check d-block d-sm-none"></i>
                            <span class="d-none d-sm-block">Ya, Hapus</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left" id="newBahanModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel19">Tambahkan Bahan Baru</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="<?php echo e(url('/admin/bahan-gudang/new')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="container">
                            <div class="mb-3">
                                <label for="">Nama Bahan</label>
                                <input type="text" required class="form-control" id="nama_bahan" name="nama_bahan">
                            </div>
                            <div class="mb-3">
                                <label for="">Stok Awal Bahan</label>
                                <input type="number" required class="form-control" id="total_stok" name="total_stok">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary btn-sm" data-bs-dismiss="modal">
                            <i class="bx bx-x d-block d-sm-none"></i>
                            <span class="d-sm-block d-none">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1 btn-sm" data-bs-dismiss="modal">
                            <i class="bx bx-check d-block d-sm-none"></i>
                            <span class="d-sm-block d-none">Submit</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left" id="addBahanModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel19">Tambahkan Nilai Bahan</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="<?php echo e(url('/admin/bahan-gudang/add')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="modal-body">
                        <div class="container">
                            <input type="hidden" name="bahan_id_add" id="bahan_id_add" value="">
                            <div class="mb-3">
                                <label for="">Nilai Bahan yang Di Tambahkan</label>
                                <input type="number" class="form-control" required id="add_bahan" name="add_bahan">
                            </div>
                            <div class="mb-3">
                                <label for="">Keterangan (Opsional)</label>
                                <textarea class="form-control" id="keterangan" name="keterangan"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary btn-sm" data-bs-dismiss="modal">
                            <i class="bx bx-x d-block d-sm-none"></i>
                            <span class="d-sm-block d-none">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1 btn-sm" data-bs-dismiss="modal">
                            <i class="bx bx-check d-block d-sm-none"></i>
                            <span class="d-sm-block d-none">Tambahkan</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade text-left" id="minusBahanModal" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel19" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel19">Kurangi Nilai Bahan</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i data-feather="x"></i>
                    </button>
                </div>
                <form action="<?php echo e(url('/admin/bahan-gudang/minus')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="modal-body">
                        <div class="container">
                            <input type="hidden" name="bahan_id_minus" id="bahan_id_minus" value="">
                            <div class="mb-3">
                                <label for="">Nilai Bahan yang Dikurangi</label>
                                <input type="number" class="form-control" required id="minus_bahan" name="minus_bahan">
                            </div>
                            <div class="mb-3">
                                <label for="">Keterangan (Opsional)</label>
                                <textarea class="form-control" id="keterangan" name="keterangan"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light-secondary btn-sm" data-bs-dismiss="modal">
                            <i class="bx bx-x d-block d-sm-none"></i>
                            <span class="d-sm-block d-none">Close</span>
                        </button>
                        <button type="submit" class="btn btn-primary ms-1 btn-sm" data-bs-dismiss="modal">
                            <i class="bx bx-check d-block d-sm-none"></i>
                            <span class="d-sm-block d-none">Kurangi</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>

    <script>
        function setId(id) {
            $("#bahan_id_add").val(id);
            $("#bahan_id_minus").val(id);
            $("#bahan_id_delete").val(id);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.admin_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\pinjam_barang\resources\views/admin/master/bahan_gudang.blade.php ENDPATH**/ ?>