<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($title); ?></title>
    <link rel="stylesheet" href="/assets/compiled/css/app.css">
    
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.0/dist/JsBarcode.all.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>

</head>

<body class="bg-white">
                
                <?php if($kode == 'qrcode'): ?>
                <div class="row row-cols-5" id="qrcode_container">
                    
                    <?php $__currentLoopData = $kode_barangs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col d-flex align-items-center flex-column">
                            <canvas id="qrcode-<?php echo e($i); ?>"></canvas>
                            <code class="fs-5"><?php echo e($item->kode_barang); ?></code>
                            <script>
                                generateQrCode(<?php echo json_encode($item->kode_barang, 15, 512) ?>, <?php echo json_encode($i, 15, 512) ?>)

                                function generateQrCode(text, i) {
                                    new QRious({
                                        element: document.getElementById(`qrcode-${i}`),
                                        background: '#ffffff',
                                        backgroundAlpha: 1,
                                        foreground: '#000',
                                        foregroundAlpha: 1,
                                        level: 'H',
                                        padding: 10,
                                        size: 150,
                                        value: text,
                                    });
                                }
                            </script>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            
            <?php if($kode == 'barcode'): ?>
                <div class="row row-cols-3" id="barcode_container">
                    
                    <?php $__currentLoopData = $kode_barangs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col d-flex align-items-center flex-column">
                            <canvas id="barcode-<?php echo e($i); ?>"></canvas>
                            <script>
                                generateBarcode(<?php echo json_encode($item->kode_barang, 15, 512) ?>, <?php echo json_encode($i, 15, 512) ?>)

                                function generateBarcode(text, i) {
                                    JsBarcode(document.getElementById(`barcode-${i}`), text, {
                                        format: 'CODE128',
                                        displayValue: true,
                                        width: 1.5,
                                        height: 70,
                                    });
                                }
                            </script>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
<?php /**PATH E:\laragon\www\pinjam_barang\resources\views/admin/master/kode_barang_cetak.blade.php ENDPATH**/ ?>