<?php $__env->startSection('content_admin'); ?>
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">

    <div class="row">
        <div class="col-12">
            <?php echo $__env->make('alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Rekap Aktivitas Keluar Masuk Bahan Gudang</h4>
                    <div class="d-flex justify-content-start align-items-center gap-3">
                        <button class="btn btn-primary d-flex justify-content-center align-items-center"
                            data-bs-toggle="modal" data-bs-target="#filterModal">
                            <i class="bi bi-funnel-fill mb-2 me-md-2"></i>
                            <small class="d-none d-md-block">Filter</small>
                        </button>
                        <button id="clear_filter" onclick="window.location.href = '/admin/aktivitas-bahan'"
                        class="btn btn-light-danger d-none d-flex justify-content-center align-items-center">
                        <i class="bi bi-x-octagon-fill mb-2 me-md-2"></i>
                        <small class="d-none d-md-block">Bersihkan Filter</small>
                    </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Bahan</th>
                                    <th>Nilai Bahan</th>
                                    <th>Waktu</th>
                                    <th>Keterangan</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="barcode-text"><?php echo e($i + 1); ?></td>
                                        <td><?php echo e($item->bahan->nama_bahan); ?></td>
                                        <td><?php echo e($item->total_bahan); ?></td>
                                        <td><?php echo e(date_format(date_create($item->waktu), 'd M Y | H:i')); ?></td>
                                        <td>
                                            <?php if($item->keterangan): ?>
                                                <?php echo e($item->keterangan); ?>

                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-capitalize">
                                            <span
                                                class="badge bg-light-<?php echo e($item->status_aktivitas == 'masuk' ? 'primary' : 'danger'); ?>"><?php echo e($item->status_aktivitas); ?></span>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade text-left" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel19">Terapkan Filter</h4>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="d-flex flex-column flex-md-row justify-content-start align-items-center gap-3">
                    <a class="btn btn-light-primary w-100" href="<?php echo e(url('/admin/aktivitas-bahan?f=masuk')); ?>">
                        <i class="bi bi-funnel-fill mb-2 me-1"></i>
                        <small class="fw-semibold">Hanya Bahan Masuk</small>
                    </a>
                    <a class="btn btn-light-danger w-100" href="<?php echo e(url('/admin/aktivitas-bahan?f=keluar')); ?>">
                        <i class="bi bi-funnel-fill mb-2 me-1"></i>
                        <small class="fw-semibold">Hanya Bahan Keluar</small>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>

    <script>
                window.onload = () => {
            let params = new URLSearchParams(window.location.search);
            if (params.get('f')) {
                $("#clear_filter").removeClass('d-none');
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.admin_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\pinjam_barang\resources\views/admin/transaksi/bahan_activites.blade.php ENDPATH**/ ?>