
<?php $__env->startSection('content'); ?>
    <style>
        #remove {
            cursor: pointer;
        }
    </style>

    <h1 class="fw-bold fs-4 mb-2">Konfirmasi Pengembalian Barang</h1>
    <div class="mt-4">
        <div class="container">
            <div class="d-flex justify-content-start align-items-start mb-2">
                <div class="w-50">
                    <table class="table me-5">
                        <tbody>
                            <tr>
                                <th scope="row">NIS / NISN</th>
                                <td><?php echo e($data->nis); ?> / <?php echo e($data->nisn); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Nama</th>
                                <td><?php echo e($data->nama); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Gender</th>
                                <td><?php echo e($data->gender); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Kelas</th>
                                <td><?php echo e($data->kelas->kelas); ?></td>
                            </tr>
                        </tbody>
                    </table>
                    <?php if($barangs->count() > 0): ?>
                        <div class="badge bg-light-success">
                            <span><?php echo e($barangs->count()); ?> Barang Tersisa</span>
                        </div>
                    <?php else: ?>
                        <div class="badge bg-light-success">
                            <span>Tidak ada barang yang dipinjam</span>
                        </div>
                    <?php endif; ?>
                    <div class="mt-2">
                        <a href="/kembalikan" class="btn btn-danger w-100 btn-sm">Kembali Menu Utama</a>
                    </div>
                    <div class="mt-3">
                        <?php echo $__env->make('alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>

                
                <div class="ms-5 w-75">
                    <h1 class="fw-medium fs-5 mb-3">List Barang Yang Dikembalikan</h1>
                    <form class="form-group" action="<?php echo e(url('/kembalikan')); ?>" method="POST"
                        onsubmit="beforeSubmit(<?php echo e($barangs); ?>)">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="user_id" id="user_id" value="<?php echo e($data->id); ?>">
                        <input type="hidden" name="pinjam_id" id="pinjam_id" value="">
                        <input required placeholder="Scan QR Code atau Barcode" autocomplete="off" autofocus type="text"
                            class="form-control form-control-sm" name="kode_barang" id="kode_barang">
                    </form>
                    <div class="container">
                        <ul class="list-group mt-4" id="list_barang">
                            <?php $__currentLoopData = $barangs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item">
                                    <small>
                                        <div class="position-absolute d-flex justify-content-center align-items-center h-100 top-50 translate-middle start-0">
                                            <div class="bg-light-success border border-warning rounded px-2 py-2 d-flex justify-content-center align-items-center">
                                                <span class="fs-3"><?php echo e($i + 1); ?></span>
                                            </div>
                                        </div>
                                        <div class="ms-4">
                                            <div class="d-flex justify-content-start align-items-center mb-1">
                                                <div class="fw-bold w-25">Nama Barang</div>
                                                <div class=""><?php echo e($item->barang->nama_barang); ?></div>
                                            </div>

                                            <div class="d-flex justify-content-start align-items-center mb-1">
                                                <div class="fw-bold w-25">Jumlah Barang</div>
                                                <div class=""><?php echo e($item->barang->jumlah_satuan); ?> Buah</div>
                                            </div>
                                            <div class="d-flex justify-content-start align-items-center mb-1">
                                                <div class="fw-bold w-25">Waktu Peminjaman</div>
                                                <div class=""><?php echo e($item->waktu_pinjam); ?></div>
                                            </div>
                                            <div class="d-flex justify-content-start align-items-center mb-1">
                                                <div class="fw-bold w-25">Keterangan</div>
                                                <div class=""><?php echo e($item->keterangan ? $item->keterangan : '-'); ?></div>
                                            </div>
                                        </div>
                                    </small>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        const kode_barang = document.getElementById('kode_barang');
        const pinjam_id = document.getElementById('pinjam_id');

        function beforeSubmit(data) {
            const result = data.find(item => item.barang.kode_barang == kode_barang.value);
            if(result){
                pinjam_id.value = result.id;
            }else{
                pinjam_id.value = "sherryl";
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('siswa.template_siswa', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\pinjam_barang\resources\views/siswa/kembalikan/kembalikan_confirm.blade.php ENDPATH**/ ?>