<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($title); ?> - <?php echo e(date('d F Y')); ?></title>
    <link rel="stylesheet" href="/assets/compiled/css/app.css">

</head>

<body class="bg-white">
    <div class="mt-4">
        <h3 class="">Laporan Data Barang Gudang Ajaib TJKT</h3>
        <div class="d-flex justify-content-start align-items-center gap-2 mb-2">
            <div class="">Tanggal Dicetak :</div>
            <span><?php echo e(date('d F Y | H : i')); ?></span>
        </div>
        <div class="d-flex flex-column p-2 bg-info-subtle w-100 rounded mb-4">
            <div class="fw-bold mb-1">Total Stok Barang Sekarang</div>
            <?php $__currentLoopData = $tipe_barangs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="d-flex gap-3">
                    <div class="" style="width : 25%"><?php echo e($item->tipe_barang); ?></div>
                    <div class="">: <?php echo e($item->total_stok); ?> Buah</div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <table class="table table-striped">
            <thead class="bg-primary">
                <th class="text-white">No</th>
                <th class="text-white">Kode Barang</th>
                <th class="text-white">Nama Barang</th>
                <th class="text-white">Tipe Barang</th>
                <th class="text-white">Jumlah Barang</th>
                <th class="text-white">Status Barang</th>
            </thead>
            <tbody>
                <?php $__currentLoopData = $barangs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="<?php echo e($item->status_barang == 'dipinjam' ? 'bg-danger' : ''); ?>">
                        <td class="<?php echo e($item->status_barang == 'dipinjam' ? 'text-white' : ''); ?>"><?php echo e($i + 1); ?></td>
                        <td class="<?php echo e($item->status_barang == 'dipinjam' ? 'text-white' : ''); ?>"><?php echo e($item->kode_barang); ?></td>
                        <td class="<?php echo e($item->status_barang == 'dipinjam' ? 'text-white' : ''); ?>"><?php echo e($item->nama_barang); ?></td>
                        <td class="<?php echo e($item->status_barang == 'dipinjam' ? 'text-white' : ''); ?>"><?php echo e($item->tipe_barang->tipe_barang); ?></td>
                        <td class="<?php echo e($item->status_barang == 'dipinjam' ? 'text-white' : ''); ?>"><?php echo e($item->jumlah_satuan); ?></td>
                        <td class="<?php echo e($item->status_barang == 'dipinjam' ? 'text-white' : ''); ?>"><?php echo e($item->status_barang); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <script>
        window.onload = () => window.print()
    </script>
</body>

</html>
<?php /**PATH E:\laragon\www\pinjam_barang\resources\views/admin/master/barang_gudang_export.blade.php ENDPATH**/ ?>