@extends('admin.admin_template')
@section('content_admin')
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="/assets/compiled/css/table-datatable-jquery.css">

    <div class="row">
        <div class="col-12">
            @include('alert')
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Rekap Aktivitas Keluar Masuk Bahan Gudang</h4>
                    <div class="d-flex justify-content-start align-items-center gap-3">
                        <button class="btn btn-primary d-flex justify-content-center align-items-center"
                            data-bs-toggle="modal" data-bs-target="#filterModal">
                            <i class="bi bi-funnel-fill mb-2 me-md-2"></i>
                            <small class="d-none d-md-block">Filter</small>
                        </button>
                        <button id="clear_filter" onclick="window.location.href = '/admin/aktivitas-bahan'"
                        class="btn btn-light-danger d-none d-flex justify-content-center align-items-center">
                        <i class="bi bi-x-octagon-fill mb-2 me-md-2"></i>
                        <small class="d-none d-md-block">Bersihkan Filter</small>
                    </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive datatable-minimal">
                        <table class="table" id="table2">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Bahan</th>
                                    <th>Nilai Bahan</th>
                                    <th>Waktu</th>
                                    <th>Keterangan</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($activities as $i => $item)
                                    <tr>
                                        <td class="barcode-text">{{ $i + 1 }}</td>
                                        <td>{{ $item->bahan->nama_bahan }}</td>
                                        <td>{{ $item->total_bahan }}</td>
                                        <td>{{ date_format(date_create($item->waktu), 'd M Y | H:i') }}</td>
                                        <td>
                                            @if ($item->keterangan)
                                                {{ $item->keterangan }}
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td class="text-capitalize">
                                            <span
                                                class="badge bg-light-{{ $item->status_aktivitas == 'masuk' ? 'primary' : 'danger' }}">{{ $item->status_aktivitas }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade text-left" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel19"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel19">Terapkan Filter</h4>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="d-flex flex-column flex-md-row justify-content-start align-items-center gap-3">
                    <a class="btn btn-light-primary w-100" href="{{ url('/admin/aktivitas-bahan?f=masuk') }}">
                        <i class="bi bi-funnel-fill mb-2 me-1"></i>
                        <small class="fw-semibold">Hanya Bahan Masuk</small>
                    </a>
                    <a class="btn btn-light-danger w-100" href="{{ url('/admin/aktivitas-bahan?f=keluar') }}">
                        <i class="bi bi-funnel-fill mb-2 me-1"></i>
                        <small class="fw-semibold">Hanya Bahan Keluar</small>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

    <script src="/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/static/js/pages/datatables.js"></script>

    <script>
                window.onload = () => {
            let params = new URLSearchParams(window.location.search);
            if (params.get('f')) {
                $("#clear_filter").removeClass('d-none');
            }
        }
    </script>
@endsection
