<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bahan_activities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bahan_id')->constrained();
            $table->integer('total_bahan');
            $table->enum('status_aktivitas', ['masuk', 'keluar']);
            $table->dateTime('waktu');
            $table->text('keterangan')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bahan_activities');
    }
};
