<?php

namespace App\Imports;

use App\Models\User;
use App\Models\Kelas;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class SiswaImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        $kelas = Kelas::where('kelas', $row['kelas'])->first();
        if(!empty($kelas)){
            return new User([
                'nis' => $row['nis'],
                'nama' => $row['nama'],
                'gender' => $row['gender'],
                'kelas_id' => $kelas['id'],
            ]);
        }
    }
}
