<?php

namespace App\Http\Controllers;

use App\Models\Bahan;
use App\Models\BahanActivity;
use Carbon\Carbon;
use Illuminate\Http\Request;

class BahanController extends Controller
{
    public function index()
    {
        $bahans = Bahan::all();
        return view('admin.master.bahan_gudang', ['title' => 'Bahan Gudang'], compact('bahans'));
    }

    public function newBahan(Request $request){
        $request->validate([
            'nama_bahan' => "required",
            'total_stok' => "required",
        ]);

        $bahan = Bahan::create($request->all());
        if($bahan){
            $activity = BahanActivity::create([
                'bahan_id' => $bahan->id,
                'total_bahan' => intval($request->total_stok),
                'waktu' => Carbon::now(),
                'keterangan' => $request->keterangan,
                'status_aktivitas' => 'masuk',
            ]);
        }
        return back()->with('success', 'Bahan Baru Berhasil Ditambahkan');
    }

    public function addBahan(Request $request)
    {
        $request->validate([
            'add_bahan' => 'required',
            'bahan_id_add' => 'required',
        ]);

        $bahan = Bahan::where('id', $request->bahan_id_add)->first();
        if ($bahan) {
            $current_stok = intval($bahan->total_stok);
            $bahan->update([
                'total_stok' => $current_stok + intval($request->add_bahan),
            ]);
            $activity = BahanActivity::create([
                'bahan_id' => $bahan['id'],
                'total_bahan' => intval($request->add_bahan),
                'waktu' => Carbon::now(),
                'keterangan' => $request->keterangan,
                'status_aktivitas' => 'masuk',
            ]);
        }
        return back()->with('success', 'Stok Bahan Berhasil Ditambah');
    }

    public function minusBahan(Request $request)
    {
        $request->validate([
            'minus_bahan' => 'required',
            'bahan_id_minus' => 'required',
        ]);

        $bahan = Bahan::where('id', $request->bahan_id_minus)->first();
        if ($bahan) {
            $current_stok = intval($bahan->total_stok);
            $bahan->update([
                'total_stok' => $current_stok - intval($request->minus_bahan),
            ]);
            $activity = BahanActivity::create([
                'bahan_id' => $bahan['id'],
                'total_bahan' => intval($request->minus_bahan),
                'waktu' => Carbon::now(),
                'keterangan' => $request->keterangan,
                'status_aktivitas' => 'keluar',
            ]);
        }
        return back()->with('success', 'Stok Bahan Berhasil Dikurangi');
    }

    public function destroy(Request $request){
        $request->validate([
            'bahan_id_delete' => "required"
        ]);
        $bahan = Bahan::where('id', $request->bahan_id_delete)->first();
        if($bahan){
            $activities = BahanActivity::where('bahan_id', $bahan['id'])->get();
            foreach($activities as $item){
                $item->delete();
            }
            $bahan->delete();
        }
        return back()->with('success', 'Bahan Berhasil Dihapus');
    }

    public function activities(Request $request){
        if($request->has('f')){
            $activities = BahanActivity::with('bahan')->where('status_aktivitas', $request->f)->latest()->get();
        }else{
            $activities = BahanActivity::with('bahan')->latest()->get();
        }
        return view('admin.transaksi.bahan_activites', compact('activities'), ['title' => 'Aktivitas Bahan']);
    }
}
