

<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="row mt-5">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header py-5 text-center mb-5 mx-2" style="border-bottom: 4px solid rgb(151, 151, 151);">
                    <h2 class="card-title">SMKN 2 Kudus</h2>
                    <h4 class="card-title">Daftar Antrian Siswa</h4>
                </div>
                <div class="card-body">
                    <table class="table table-striped" id="queueTable">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Tanggal Buka</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $queues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $queue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($queue->kuota); ?></td>
                                    <td><?php echo e($queue->tanggal_buka); ?></td>
                                    <td>
                                        <!-- Tambahkan atribut data untuk queue ID dan kuota -->
                                        <button class="btn btn-primary btnPrintQueue" data-queue="<?php echo e($queue->id); ?>" data-kuota="<?php echo e($queue->kuota); ?>">Cetak</button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal Kartu Antrian -->
    <div class="modal fade" id="modalKartuAntrian" tabindex="-1" aria-labelledby="modalKartuAntrianLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalKartuAntrianLabel">Kartu Antrian</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="kartuAntrianContent"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="btnTutupModal">Tutup</button>
                    <!-- Ubah id button cetak -->
                    <button type="button" class="btn btn-primary" id="btnCetakKartuAntrian">Cetak</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {

            $(document).on('click', '.btnPrintQueue', function(event) {
                event.preventDefault();
                var queueId = $(this).data('queue');
                var kuota = $(this).data('kuota');

                $.ajax({
                    url: '<?php echo e(route('print.data.kasir')); ?>',
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        queue_id: queueId
                    },
                    success: function(response) {
                        $('#kartuAntrianContent').html(response.kartuAntrian);
                        $('#modalKartuAntrian').modal('show');
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                    }
                });
            });

            $('#btnCetakKartuAntrian').click(function() {
                var printWindow = window.open('', '_blank');
                printWindow.document.write($('#kartuAntrianContent').html());

                setTimeout(function() {
                    printWindow.print();
                }, 1000);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zona4001/antrian/resources/views/petugas/list.blade.php ENDPATH**/ ?>