

<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <a href="<?php echo e(route('Admin.users.create')); ?>" class="btn btn-primary m-2">Tambah User</a>
                    <form action="<?php echo e(route('Admin.users')); ?>" method="GET" class="mb-3">
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="Cari Username" name="search"
                                value="<?php echo e(request('search')); ?>">
                            <button type="submit" class="btn btn-outline-secondary">Cari</button>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Username</th>
                                    <th>Level</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr id="table_user">
                                        <td><?php echo e($u->name); ?></td>
                                        <td><?php echo e($u->username); ?></td>
                                        <td><?php echo e($u->level); ?></td>
                                        <td class="d-flex gap-3">
                                            <button class="btn btn-sm btn-warning btn-edit-user"
                                                data-id="<?php echo e($u->id); ?>">Edit</button>

                                            <form method="POST"
                                                action="<?php echo e(route('Admin.users.delete', ['user_id' => $u->id])); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit"
                                                    class="btn btn-sm btn-danger btn-delete">Delete</button>
                                            </form>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6">Tidak ada data user</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <?php echo e($user->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editUserLabel">Edit Data Penduduk</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editPendudukForm" method="PUT"
                        action="<?php echo e(route('Admin.users.update', ['user_id' => $u->id])); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="edit_name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="edit_name" name="edit_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_username" class="form-label">Username</label>
                            <input type="text" class="form-control" id="edit_username" name="edit_username" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_level" class="form-label">Level</label>
                            <select class="form-select" id="edit_level" name="edit_level" required>
                                <option value="">Pilih Level</option>
                                <option value="Admin">Admin</option>
                                <option value="Operator">Operator</option>
                                <option value="Petugas">Petugas</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="edit_password" class="form-label">Password</label>
                            <input type="password" class="form-control" id="edit_password" name="edit_password" required>
                        </div>
                        <button type="submit" class="btn btn-primary btn-save-user"
                            data-id="<?php echo e(isset($u) ? $u->id : null); ?>">Simpan
                            Perubahan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Vendors JS -->
    <script src="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')); ?>"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('/vendor/datatables/buttons.server-side.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            $('.btn-edit-user').click(function(event) {
                event.preventDefault();
                var id = $(this).data('id');
                var baseUrl = "<?php echo e(url('/')); ?>";
                var editUrl = baseUrl + "/admin/users/" + id + "/edit";
                $.ajax({
                    url: editUrl,
                    type: 'GET',
                    success: function(response) {
                        $('#edit_name').val(response.name);
                        $('#edit_username').val(response.username);
                        $('#edit_level').val(response.level);
                        $('#edit_password').val(response.password);
                        $('#editUserModal').modal('show');
                        $('.btn-save-user').data('id', id);
                    }
                });
            });

            $('.btn-save-user').click(function(event) {
                event.preventDefault();
                // Ambil ID penduduk dari atribut data pada tombol "Simpan Perubahan"
                var id = $(this).data('id');
                var baseUrl = "<?php echo e(url('/')); ?>";
                var updateUrl = baseUrl + "/admin/users/" + id;
                var name = $('#edit_name').val();
                var username = $('#edit_username').val();
                var level = $('#edit_level').val();
                var password = $('#edit_password').val();
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: updateUrl,
                    type: 'PUT',
                    data: {
                        _token: csrfToken,
                        name: name,
                        username: username,
                        level: level,
                        password: password,
                    },
                    success: function(response) {
                        $('#table_user').find('td:eq(0)').text(response.name);
                        $('#table_user').find('td:eq(1)').text(response.username);
                        $('#table_user').find('td:eq(2)').text(response.level);
                        $('#editUserModal').modal('hide');
                        location.reload();
                        alert('Data penduduk berhasil diperbarui!');
                    },
                    error: function(xhr, status, error) {
                        console.error(xhr.responseText);
                        // alert('Data penduduk berhasil diperbarui!');
                        // location.reload();
                    }
                });
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.btn-delete').click(function(event) {
                event.preventDefault();
                var form = $(this).closest('form');
                var confirmMessage = "Apakah Anda yakin ingin menghapus data ini?";
                if (confirm(confirmMessage)) {
                    form.submit();
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zona4001/antrian/resources/views/admin/user/index.blade.php ENDPATH**/ ?>