<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="row">
        <h4 class="mb-3">Admin Dashboard Aplikasi Antrian</h4>
        <div class="row">
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body px-4 py-4-5">
                        <div class="row">
                            <div class="col-md-3 col-lg-12 col-xl-12 col-xxl-2 d-flex justify-content-start">
                                <div class="stats-icon green mb-2">
                                    <img width="40" height="40" src="https://img.icons8.com/ios-filled/40/queue.png"
                                        alt="queue" />
                                </div>
                            </div>
                            <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                <h6 class="font-extrabold fs-3"><?php echo e($totalAntrian); ?></h6>
                                <h6 class="text-muted font-semibold">Total Antrian</h6>
                                <a href="#" class="btn btn-lg btn-success w-100">
                                    <span class="fw-semibold fs-6">Cetak</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body px-4 py-4-5">
                        <div class="row">
                            <div class="col-md-3 col-lg-12 col-xl-12 col-xxl-2 d-flex justify-content-start">
                                <div class="stats-icon blue mb-2">
                                    <i class="h1 iconly-boldCalendar"></i>
                                </div>
                            </div>
                            <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                <h6 class="font-extrabold fs-3"><?php echo e($antrianMenunggu); ?></h6>
                                <h6 class="text-muted font-semibold">Antrian Menunggu</h6>
                                <a href="#" class="btn btn-lg btn-primary w-100">
                                    <span class="fw-semibold fs-6">Lihat Riwayat</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body px-4 py-4-5">
                        <div class="row">
                            <div class="col-md-3 col-lg-12 col-xl-12 col-xxl-2 d-flex justify-content-start">
                                <div class="stats-icon blue mb-2">
                                    <i class="h1 iconly-boldCalendar"></i>
                                </div>
                            </div>
                            <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                <h6 class="font-extrabold fs-3"><?php echo e($antrianDiproses); ?></h6>
                                <h6 class="text-muted font-semibold">Antrian Diproses</h6>
                                <a href="#" class="btn btn-lg btn-primary w-100">
                                    <span class="fw-semibold fs-6">Lihat Riwayat</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-3">
                    <div class="card-body px-4 py-4-5">
                        <div class="row">
                            <div class="col-md-3 col-lg-12 col-xl-12 col-xxl-2 d-flex justify-content-start">
                                <div class="stats-icon blue mb-2">
                                    <i class="h1 iconly-boldCalendar"></i>
                                </div>
                            </div>
                            <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                <h6 class="font-extrabold fs-3"><?php echo e($antrianSelesai); ?></h6>
                                <h6 class="text-muted font-semibold">Antrian Selesai</h6>
                                <a href="#" class="btn btn-lg btn-primary w-100">
                                    <span class="fw-semibold fs-6">Lihat Riwayat</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Daftar Antrian</h4>
                    </div>
                    <div class="card-body">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="antrian_table" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>Nomor Antrian</th>
                                            <th>Waktu Masuk</th>
                                            <th>Status</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $daftarAntrian; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $antrian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr id="table_antrian">
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($antrian->queue->nama_antrian); ?></td>
                                                <td><?php echo e($antrian->tanggal_masuk); ?></td>
                                                <td><?php echo e($antrian->status); ?></td>
                                                <td>
                                                    <button class="btn btn-sm btn-warning btn-edit"
                                                        data-id="<?php echo e($antrian->id); ?>">Edit</button>
                                                    <button class="btn btn-sm btn-primary btn-panggil">Panggil</button>
                                                    <form action="<?php echo e(route('Admin.delete', $antrian->id)); ?>" method="POST"
                                                        style="display: inline;">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('Apakah Anda yakin ingin menghapus antrian ini?')">Hapus</button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </section>

    
    <div class="modal fade" id="editAntrianModal" tabindex="-1" aria-labelledby="editAntrianModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editAntrianModalLabel">Edit Data Antrian</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editAntrianForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="_method" value="PUT">
                        <div class="mb-3">
                            <label for="edit_nama_antrian" class="form-label">Nama Antrian</label>
                            <input type="text" class="form-control" id="edit_nama_antrian" name="edit_nama_antrian" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_status" class="form-label">Asal Sekolah</label>
                            <option value="Ubah Status"></option>
                            <option value=""></option>
                        </div>
                        <button type="submit" class="btn btn-primary btn-save">Simpan Perubahan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Vendors JS -->
    <script src="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')); ?>"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('/vendor/datatables/buttons.server-side.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            $('.btn-edit').click(function() {
                var id = $(this).data('id');
                var baseUrl = "<?php echo e(url('/')); ?>";
                var editUrl = baseUrl + "/admin/antrian/" + id + "/edit";
                $.ajax({
                    url: editUrl,
                    type: 'GET',
                    success: function(response) {
                        $('#edit_nama_antrian').val(response.nama_antrian);
                        $('#edit_asal_sekolah').val(response.asal_sekolah);
                        $('#editAntrianModal').modal('show');
                        $('.btn-save').data('id', response.id);
                    }
                });
            });

            $('.btn-save').click(function(event) {
                var id = $(this).data('id');
                var baseUrl = "<?php echo e(url('/')); ?>";
                var updateUrl = baseUrl + "/admin/antrian/" + id;
                var namaAntrian = $('#edit_nama_antrian').val();
                var status = $('#edit_asal_sekolah').val();
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: updateUrl,
                    type: 'PUT',
                    data: {
                        _token: csrfToken,
                        nama_antrian: namaAntrian,
                        asal_sekolah: status
                    },
                    success: function(response) {
                        $('#table_antrian').find('td:eq(1)').text(response.nama_antrian);
                        $('#table_antrian').find('td:eq(2)').text(response.asal_sekolah);
                        $('#editAntrianModal').modal('hide');
                    }
                });
            });

            $('.btn-panggil').click(function() {
                var id = $(this).closest('tr').find('td:first-child').text();
                var audioElement = document.createElement('audio');

                audioElement.src = "/assets/audio/Antrian ke " + id + ".mp3";
                audioElement.play();

            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\antrian\resources\views/admin/index.blade.php ENDPATH**/ ?>