<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="/assets/compiled/css/iconly.css">
    <link rel="stylesheet" href="/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="./assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="row">
        <h4 class="mb-3">Admin Dashboard Aplikasi Antrian</h4>
        <div class="row">
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body px-4 py-4-5">
                        <div class="row">
                            <div class="col-md-3 col-lg-12 col-xl-12 col-xxl-2 d-flex justify-content-start">
                                <div class="stats-icon green mb-2">
                                    <i class="menu-icon tf-icons mdi mdi-account-multiple"></i>
                                </div>
                            </div>
                            <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                <h6 class="font-extrabold fs-3"><?php echo e($totalAntrian); ?></h6>
                                <h6 class="text-muted font-semibold">Total Daftar Antrian</h6>
                                <a href="<?php echo e(route('Admin.riwayat.all')); ?>" class="btn btn-lg btn-success w-100">
                                    <span class="fw-semibold fs-6">Lihat Semua</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body px-4 py-4-5">
                        <div class="row">
                            <div class="col-md-3 col-lg-12 col-xl-12 col-xxl-2 d-flex justify-content-start">
                                <div class="stats-icon blue mb-2">
                                    <i class="menu-icon tf-icons mdi mdi-account-multiple"></i>
                                </div>
                            </div>
                            <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                <h6 class="font-extrabold fs-3"><?php echo e($antrianMenunggu); ?></h6>
                                <h6 class="text-muted font-semibold">Antrian Menunggu</h6>
                                <a href="<?php echo e(route('Admin.riwayat.tunggu')); ?>" class="btn btn-lg btn-primary w-100">
                                    <span class="fw-semibold fs-6">Lihat Riwayat</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body px-4 py-4-5">
                        <div class="row">
                            <div class="col-md-3 col-lg-12 col-xl-12 col-xxl-2 d-flex justify-content-start">
                                <div class="stats-icon blue mb-2">
                                    <i class="menu-icon tf-icons mdi mdi-account-settings"></i>
                                </div>
                            </div>
                            <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                <h6 class="font-extrabold fs-3"><?php echo e($antrianDiproses); ?></h6>
                                <h6 class="text-muted font-semibold">Antrian Diproses</h6>
                                <a href="<?php echo e(route('Admin.riwayat.proses')); ?>" class="btn btn-lg btn-primary w-100">
                                    <span class="fw-semibold fs-6">Lihat Riwayat</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-3">
                    <div class="card-body px-4 py-4-5">
                        <div class="row">
                            <div class="col-md-3 col-lg-12 col-xl-12 col-xxl-2 d-flex justify-content-start">
                                <div class="stats-icon blue mb-2">
                                    <i class="menu-icon tf-icons mdi mdi-account-check"></i>
                                </div>
                            </div>
                            <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                <h6 class="font-extrabold fs-3"><?php echo e($antrianSelesai); ?></h6>
                                <h6 class="text-muted font-semibold">Antrian Selesai</h6>
                                <a href="<?php echo e(route('Admin.riwayat.selesai')); ?>" class="btn btn-lg btn-primary w-100">
                                    <span class="fw-semibold fs-6">Lihat Riwayat</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="card-title">Daftar Antrian</h4>
                            <button id="btnHapusSemua" class="btn btn-danger">Hapus Semua Antrian</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="antrian_table" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>Waktu Masuk</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $daftarAntrian; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $antrian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr id="table_antrian">
                                                <td><?php echo e($antrian->queue->kuota); ?></td>
                                                <td><?php echo e($antrian->tanggal_masuk); ?></td>
                                                <td><?php echo e($antrian->status); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="text-center mt-4">
                            <a href="<?php echo e(route('Admin.riwayat.all')); ?>" class="btn btn-primary">Lihat Semua Daftar
                                Antrian</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Vendors JS -->
    <script src="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')); ?>"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('/vendor/datatables/buttons.server-side.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            $('.btn-panggil').click(function() {
                var row = $(this).closest('tr');
                var id = row.find('td:first-child').text();
                var status = row.find('td:eq(2)').text();
                var audioElement = document.createElement('audio');
                var baseUrl = "<?php echo e(url('/')); ?>";
                var updateUrl = baseUrl + "/admin/antrian/status/" + id;
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                if (status !== "Selesai") {
                    var msg = new SpeechSynthesisUtterance('Antrian nomor ' + id + ' menuju Admin');
                    msg.lang = 'id-ID';
                    window.speechSynthesis.speak(msg);

                    var button = $(this);

                    $.ajax({
                        url: updateUrl,
                        type: 'PUT',
                        data: {
                            _token: csrfToken,
                            status: "Diproses"
                        },
                        success: function(response) {
                            button.closest('tr').find('td:eq(2)').text("Diproses");
                        }
                    });
                }
            });

            $('.btn-selesai').click(function() {
                var row = $(this).closest('tr');
                var id = row.find('td:first-child').text();
                var status = row.find('td:eq(2)').text();
                var baseUrl = "<?php echo e(url('/')); ?>";
                var updateUrl = baseUrl + "/admin/antrian/status/check/" + id;
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                if (status !== "Selesai") {
                    var button = $(this);

                    $.ajax({
                        url: updateUrl,
                        type: 'PUT',
                        data: {
                            _token: csrfToken,
                            status: "Selesai"
                        },
                        success: function(response) {
                            button.closest('tr').find('td:eq(2)').text("Selesai");
                        }
                    });
                }
            });

            $('#btnHapusSemua').click(function() {
                if (confirm('Apakah Anda yakin ingin menghapus semua antrian?')) {
                    var baseUrl = "<?php echo e(url('/')); ?>";
                    var deleteAllUrl = baseUrl + "/admin/antrian";
                    var csrfToken = $('meta[name="csrf-token"]').attr('content');

                    $.ajax({
                        url: deleteAllUrl,
                        type: 'DELETE',
                        data: {
                            _token: csrfToken
                        },
                        success: function(response) {
                            alert(response.success);
                            location.reload();
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\antrian\resources\views/admin/index.blade.php ENDPATH**/ ?>